/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.log;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.Dispatchers;
import io.zeebe.dispatcher.Subscription;
import io.zeebe.logstreams.impl.Loggers;
import io.zeebe.logstreams.impl.log.LogStorageAppender;
import io.zeebe.logstreams.impl.log.LogStreamBatchWriterImpl;
import io.zeebe.logstreams.impl.log.LogStreamReaderImpl;
import io.zeebe.logstreams.impl.log.LogStreamWriterImpl;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamBatchWriter;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.logstreams.log.LogStreamRecordWriter;
import io.zeebe.logstreams.log.LogStreamWriter;
import io.zeebe.logstreams.storage.LogStorage;
import io.zeebe.logstreams.storage.LogStorageReader;
import io.zeebe.util.CloseableSilently;
import io.zeebe.util.health.FailureListener;
import io.zeebe.util.health.HealthStatus;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorCondition;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.channel.ActorConditions;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;

public final class LogStreamImpl
extends Actor
implements LogStream,
FailureListener {
    private static final long INVALID_ADDRESS = -1L;
    private static final Logger LOG = Loggers.LOGSTREAMS_LOGGER;
    private static final String APPENDER_SUBSCRIPTION_NAME = "appender";
    private final ActorConditions onCommitPositionUpdatedConditions;
    private final String logName;
    private final int partitionId;
    private final int maxFrameLength;
    private final ActorScheduler actorScheduler;
    private final List<LogStreamReader> readers;
    private final LogStorage logStorage;
    private final CompletableActorFuture<Void> closeFuture;
    private final int nodeId;
    private ActorFuture<LogStorageAppender> appenderFuture;
    private Dispatcher writeBuffer;
    private LogStorageAppender appender;
    private long commitPosition;
    private Throwable closeError;
    private final String actorName;
    private FailureListener failureListener;

    LogStreamImpl(ActorScheduler actorScheduler, ActorConditions onCommitPositionUpdatedConditions, String logName, int partitionId, int nodeId, int maxFrameLength, LogStorage logStorage) {
        this.actorScheduler = actorScheduler;
        this.onCommitPositionUpdatedConditions = onCommitPositionUpdatedConditions;
        this.logName = logName;
        this.partitionId = partitionId;
        this.nodeId = nodeId;
        this.actorName = LogStreamImpl.buildActorName((int)nodeId, (String)"LogStream", (int)partitionId);
        this.maxFrameLength = maxFrameLength;
        this.logStorage = logStorage;
        this.closeFuture = new CompletableActorFuture();
        this.commitPosition = -1L;
        this.readers = new ArrayList<LogStreamReader>();
        try (LogStorageReader storageReader = logStorage.newReader();
             LogStreamReaderImpl reader = new LogStreamReaderImpl(storageReader);){
            this.internalSetCommitPosition(reader.seekToEnd());
        }
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getLogName() {
        return this.logName;
    }

    @Override
    public ActorFuture<Long> getCommitPositionAsync() {
        return this.actor.call(() -> this.commitPosition);
    }

    @Override
    public void setCommitPosition(long commitPosition) {
        this.actor.call(() -> this.internalSetCommitPosition(commitPosition));
    }

    @Override
    public ActorFuture<LogStreamReader> newLogStreamReader() {
        return this.actor.call(this::createLogStreamReader);
    }

    @Override
    public ActorFuture<LogStreamRecordWriter> newLogStreamRecordWriter() {
        if (this.actor.isClosed()) {
            return CompletableActorFuture.completedExceptionally((Throwable)new RuntimeException("Actor is closed"));
        }
        CompletableActorFuture writerFuture = new CompletableActorFuture();
        this.actor.run(() -> this.createWriter(writerFuture, LogStreamWriterImpl::new));
        return writerFuture;
    }

    @Override
    public ActorFuture<LogStreamBatchWriter> newLogStreamBatchWriter() {
        if (this.actor.isClosed()) {
            return CompletableActorFuture.completedExceptionally((Throwable)new RuntimeException("Actor is closed"));
        }
        CompletableActorFuture writerFuture = new CompletableActorFuture();
        this.actor.run(() -> this.createWriter(writerFuture, LogStreamBatchWriterImpl::new));
        return writerFuture;
    }

    @Override
    public void registerOnCommitPositionUpdatedCondition(ActorCondition condition) {
        this.actor.call(() -> this.onCommitPositionUpdatedConditions.registerConsumer(condition));
    }

    @Override
    public void removeOnCommitPositionUpdatedCondition(ActorCondition condition) {
        this.actor.call(() -> this.onCommitPositionUpdatedConditions.removeConsumer(condition));
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorClosing() {
        LOG.info("On closing logstream {} close {} readers", (Object)this.logName, (Object)this.readers.size());
        this.readers.forEach(CloseableSilently::close);
    }

    protected void onActorClosed() {
        if (this.closeError != null) {
            this.closeFuture.completeExceptionally(this.closeError);
        } else {
            this.closeFuture.complete(null);
        }
    }

    @Override
    public void close() {
        this.closeAsync().join();
    }

    public ActorFuture<Void> closeAsync() {
        if (this.actor.isClosed()) {
            return this.closeFuture;
        }
        this.actor.run(() -> this.closeAppender().onComplete((nothing, appenderError) -> {
            this.closeError = appenderError;
            this.actor.close();
        }));
        return this.closeFuture;
    }

    private LogStreamReader createLogStreamReader() {
        LogStreamReaderImpl newReader = new LogStreamReaderImpl(this.logStorage.newReader());
        this.readers.add(newReader);
        return newReader;
    }

    private void internalSetCommitPosition(long commitPosition) {
        if (commitPosition > this.commitPosition) {
            this.commitPosition = commitPosition;
            this.onCommitPositionUpdatedConditions.signalConsumers();
        }
    }

    private <T extends LogStreamWriter> void createWriter(CompletableActorFuture<T> writerFuture, WriterCreator<T> creator) {
        if (this.appender != null) {
            writerFuture.complete(creator.create(this.partitionId, this.writeBuffer));
        } else if (this.appenderFuture != null) {
            this.appenderFuture.onComplete(this.onOpenAppender(writerFuture, creator));
        } else {
            this.openAppender().onComplete(this.onOpenAppender(writerFuture, creator));
        }
    }

    private <T extends LogStreamWriter> BiConsumer<LogStorageAppender, Throwable> onOpenAppender(CompletableActorFuture<T> writerFuture, WriterCreator<T> creator) {
        return (openedAppender, errorOnOpeningAppender) -> {
            if (errorOnOpeningAppender == null) {
                writerFuture.complete(creator.create(this.partitionId, this.writeBuffer));
            } else {
                writerFuture.completeExceptionally(errorOnOpeningAppender);
            }
        };
    }

    private ActorFuture<Void> closeAppender() {
        CompletableActorFuture closeAppenderFuture = new CompletableActorFuture();
        if (this.appender == null) {
            closeAppenderFuture.complete(null);
            return closeAppenderFuture;
        }
        this.appenderFuture = null;
        LOG.info("Close appender for log stream {}", (Object)this.logName);
        LogStorageAppender toCloseAppender = this.appender;
        Dispatcher toCloseWriteBuffer = this.writeBuffer;
        this.appender = null;
        this.writeBuffer = null;
        toCloseAppender.closeAsync().onComplete((v, t) -> {
            if (t == null) {
                toCloseWriteBuffer.closeAsync().onComplete((BiConsumer)closeAppenderFuture);
            } else {
                closeAppenderFuture.completeExceptionally(t);
            }
        });
        return closeAppenderFuture;
    }

    private ActorFuture<LogStorageAppender> openAppender() {
        long initialPosition;
        CompletableActorFuture appenderOpenFuture;
        if (this.appenderFuture != null) {
            return this.appenderFuture;
        }
        this.appenderFuture = appenderOpenFuture = new CompletableActorFuture();
        long lastPosition = this.getLastPosition();
        if (lastPosition > 0L) {
            this.internalSetCommitPosition(lastPosition);
            initialPosition = lastPosition + 1L;
        } else {
            initialPosition = 1L;
        }
        this.writeBuffer = Dispatchers.create((String)LogStreamImpl.buildActorName((int)this.nodeId, (String)"dispatcher", (int)this.partitionId)).maxFragmentLength(this.maxFrameLength).initialPosition(initialPosition).name(this.logName + "-write-buffer").actorScheduler(this.actorScheduler).build();
        this.writeBuffer.openSubscriptionAsync(APPENDER_SUBSCRIPTION_NAME).onComplete((subscription, throwable) -> {
            if (throwable == null) {
                this.appender = new LogStorageAppender(LogStreamImpl.buildActorName((int)this.nodeId, (String)"LogAppender", (int)this.partitionId), this.partitionId, this.logStorage, (Subscription)subscription, this.maxFrameLength, this::setCommitPosition);
                this.actorScheduler.submitActor((Actor)this.appender).onComplete((v, t) -> {
                    if (t != null) {
                        this.onOpenAppenderFailed((Throwable)t);
                    } else {
                        this.appenderFuture.complete((Object)this.appender);
                        this.appender.addFailureListener(this);
                    }
                });
            } else {
                this.onOpenAppenderFailed((Throwable)throwable);
            }
        });
        return appenderOpenFuture;
    }

    private void onOpenAppenderFailed(Throwable error) {
        LOG.error("Unexpected error when opening appender", error);
        this.appenderFuture.completeExceptionally(error);
        this.onFailure();
    }

    private long getLastPosition() {
        try (LogStorageReader storageReader = this.logStorage.newReader();){
            long l;
            try (LogStreamReaderImpl logReader = new LogStreamReaderImpl(storageReader);){
                l = logReader.seekToEnd();
            }
            return l;
        }
    }

    public HealthStatus getHealthStatus() {
        return this.actor.isClosed() ? HealthStatus.UNHEALTHY : HealthStatus.HEALTHY;
    }

    public void addFailureListener(FailureListener failureListener) {
        this.actor.run(() -> {
            this.failureListener = failureListener;
        });
    }

    public void onFailure() {
        this.actor.run(() -> {
            if (this.failureListener != null) {
                this.failureListener.onFailure();
            }
            this.closeAsync();
        });
    }

    public void onRecovered() {
        this.actor.run(() -> {
            if (this.failureListener != null) {
                this.failureListener.onRecovered();
            }
        });
    }

    @FunctionalInterface
    private static interface WriterCreator<T extends LogStreamWriter> {
        public T create(int var1, Dispatcher var2);
    }
}

