/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.log;

import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.zeebe.EntryValidator;
import io.atomix.raft.zeebe.ValidationResult;
import io.zeebe.logstreams.impl.log.LogEntryDescriptor;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ZeebeEntryValidator
implements EntryValidator {
    public ValidationResult validateEntry(ApplicationEntry lastEntry, ApplicationEntry entry) {
        UnsafeBuffer reader = new UnsafeBuffer(entry.data());
        long lastPosition = lastEntry != null ? lastEntry.highestPosition() : -1L;
        int offset = 0;
        do {
            long position = LogEntryDescriptor.getPosition((DirectBuffer)reader, offset);
            if (lastPosition != -1L && position != lastPosition + 1L) {
                return ValidationResult.failure((String)String.format("Unexpected position %d was encountered after position %d when appending positions <%d, %d>.", position, lastPosition, entry.lowestPosition(), entry.highestPosition()));
            }
            lastPosition = position;
        } while ((offset += LogEntryDescriptor.getFragmentLength((DirectBuffer)reader, offset)) < reader.capacity());
        return ValidationResult.success();
    }
}

