/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.storage.atomix;

import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.zeebe.logstreams.storage.LogStorage;
import io.zeebe.logstreams.storage.atomix.AtomixAppendListenerAdapter;
import io.zeebe.logstreams.storage.atomix.AtomixLogStorageReader;
import io.zeebe.logstreams.storage.atomix.AtomixReaderFactory;
import java.nio.ByteBuffer;

public class AtomixLogStorage
implements LogStorage {
    private final AtomixReaderFactory readerFactory;
    private final ZeebeLogAppender logAppender;

    public AtomixLogStorage(AtomixReaderFactory readerFactory, ZeebeLogAppender logAppender) {
        this.readerFactory = readerFactory;
        this.logAppender = logAppender;
    }

    public static AtomixLogStorage ofPartition(AtomixReaderFactory readerFactory, ZeebeLogAppender appender) {
        return new AtomixLogStorage(readerFactory, appender);
    }

    @Override
    public AtomixLogStorageReader newReader() {
        return new AtomixLogStorageReader(this.readerFactory.create());
    }

    @Override
    public void append(long lowestPosition, long highestPosition, ByteBuffer buffer, LogStorage.AppendListener listener) {
        AtomixAppendListenerAdapter adapter = new AtomixAppendListenerAdapter(listener);
        this.logAppender.appendEntry(lowestPosition, highestPosition, buffer, (ZeebeLogAppender.AppendListener)adapter);
    }
}

