/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporter;

import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;

public class ElasticsearchExporterConfiguration {
    private static final String DEFAULT_URL = "http://localhost:9200";
    public String url = "http://localhost:9200";
    public final IndexConfiguration index = new IndexConfiguration();
    public final BulkConfiguration bulk = new BulkConfiguration();
    private final AuthenticationConfiguration authentication = new AuthenticationConfiguration();

    public boolean hasAuthenticationPresent() {
        return this.getAuthentication().isPresent();
    }

    public AuthenticationConfiguration getAuthentication() {
        return this.authentication;
    }

    public String toString() {
        return "ElasticsearchExporterConfiguration{url='" + this.url + "', index=" + this.index + ", bulk=" + this.bulk + "}";
    }

    public boolean shouldIndexRecord(Record<?> record) {
        return this.shouldIndexRecordType(record.getRecordType()) && this.shouldIndexValueType(record.getValueType());
    }

    public boolean shouldIndexValueType(ValueType valueType) {
        switch (valueType) {
            case DEPLOYMENT: {
                return this.index.deployment;
            }
            case ERROR: {
                return this.index.error;
            }
            case INCIDENT: {
                return this.index.incident;
            }
            case JOB: {
                return this.index.job;
            }
            case JOB_BATCH: {
                return this.index.jobBatch;
            }
            case MESSAGE: {
                return this.index.message;
            }
            case MESSAGE_SUBSCRIPTION: {
                return this.index.messageSubscription;
            }
            case VARIABLE: {
                return this.index.variable;
            }
            case VARIABLE_DOCUMENT: {
                return this.index.variableDocument;
            }
            case PROCESS_INSTANCE: {
                return this.index.processInstance;
            }
            case PROCESS_INSTANCE_CREATION: {
                return this.index.processInstanceCreation;
            }
            case PROCESS_INSTANCE_SUBSCRIPTION: {
                return this.index.processInstanceSubscription;
            }
        }
        return false;
    }

    public boolean shouldIndexRecordType(RecordType recordType) {
        switch (recordType) {
            case EVENT: {
                return this.index.event;
            }
            case COMMAND: {
                return this.index.command;
            }
            case COMMAND_REJECTION: {
                return this.index.rejection;
            }
        }
        return false;
    }

    public static class AuthenticationConfiguration {
        private String username;
        private String password;

        public boolean isPresent() {
            return this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty();
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String toString() {
            return "AuthenticationConfiguration{Confidential information}";
        }
    }

    public static class BulkConfiguration {
        public int delay = 5;
        public int size = 1000;
        public int memoryLimit = 0xA00000;

        public String toString() {
            return "BulkConfiguration{delay=" + this.delay + ", size=" + this.size + ", memoryLimit=" + this.memoryLimit + "}";
        }
    }

    public static class IndexConfiguration {
        public String prefix = "zeebe-record";
        public boolean createTemplate = true;
        public boolean command = false;
        public boolean event = true;
        public boolean rejection = false;
        public boolean deployment = true;
        public boolean error = true;
        public boolean incident = true;
        public boolean job = true;
        public boolean jobBatch = false;
        public boolean message = false;
        public boolean messageSubscription = false;
        public boolean variable = true;
        public boolean variableDocument = true;
        public boolean processInstance = true;
        public boolean processInstanceCreation = false;
        public boolean processInstanceSubscription = false;
        public int ignoreVariablesAbove = 8191;

        public String toString() {
            return "IndexConfiguration{indexPrefix='" + this.prefix + "', createTemplate=" + this.createTemplate + ", command=" + this.command + ", event=" + this.event + ", rejection=" + this.rejection + ", error=" + this.error + ", deployment=" + this.deployment + ", incident=" + this.incident + ", job=" + this.job + ", message=" + this.message + ", messageSubscription=" + this.messageSubscription + ", variable=" + this.variable + ", variableDocument=" + this.variableDocument + ", processInstance=" + this.processInstance + ", processInstanceCreation=" + this.processInstanceCreation + ", processInstanceSubscription=" + this.processInstanceSubscription + ", ignoreVariablesAbove=" + this.ignoreVariablesAbove + "}";
        }
    }
}

