/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.NodeConfig;
import io.atomix.cluster.NodeId;
import io.atomix.utils.net.Address;
import java.util.Map;
import java.util.Properties;

public class MemberConfig
extends NodeConfig {
    private MemberId id = MemberId.anonymous();
    private String zoneId;
    private String rackId;
    private String hostId;
    private Properties properties = new Properties();

    @Override
    public MemberId getId() {
        return this.id;
    }

    @Override
    public MemberConfig setId(String id) {
        return this.setId(id != null ? MemberId.from(id) : null);
    }

    @Override
    public MemberConfig setId(NodeId id) {
        return this.setId(id != null ? MemberId.from((String)((Object)id.id())) : null);
    }

    public MemberConfig setId(MemberId id) {
        this.id = id != null ? id : MemberId.anonymous();
        return this;
    }

    @Override
    public MemberConfig setHost(String host) {
        super.setHost(host);
        this.setHostId(host);
        return this;
    }

    @Override
    public MemberConfig setPort(int port) {
        super.setPort(port);
        return this;
    }

    @Override
    public MemberConfig setAddress(String address) {
        super.setAddress(address);
        return this;
    }

    @Override
    public MemberConfig setAddress(Address address) {
        super.setAddress(address);
        return this;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public MemberConfig setZoneId(String zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    public MemberConfig setZone(String zone) {
        return this.setZoneId(zone);
    }

    public String getRackId() {
        return this.rackId;
    }

    public MemberConfig setRackId(String rackId) {
        this.rackId = rackId;
        return this;
    }

    public MemberConfig setRack(String rack) {
        return this.setRackId(rack);
    }

    public String getHostId() {
        return this.hostId;
    }

    public MemberConfig setHostId(String hostId) {
        this.hostId = hostId;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public MemberConfig setProperties(Map<String, String> map) {
        Properties properties = new Properties();
        properties.putAll(map);
        return this.setProperties(properties);
    }

    public MemberConfig setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public MemberConfig setProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }
}

