/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.NodeBuilder;
import io.atomix.cluster.NodeConfig;
import io.atomix.cluster.NodeId;
import io.atomix.utils.config.Configured;
import io.atomix.utils.net.Address;
import java.util.Objects;

public class Node
implements Configured<NodeConfig> {
    private final NodeId id;
    private final Address address;

    public Node(NodeConfig config) {
        this.id = config.getId();
        this.address = (Address)Preconditions.checkNotNull((Object)config.getAddress(), (Object)"address cannot be null");
    }

    protected Node(NodeId id, Address address) {
        this.id = (NodeId)Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        this.address = (Address)Preconditions.checkNotNull((Object)address, (Object)"address cannot be null");
    }

    public static NodeBuilder builder() {
        return new NodeBuilder(new NodeConfig());
    }

    public NodeId id() {
        return this.id;
    }

    public Address address() {
        return this.address;
    }

    public NodeConfig config() {
        return new NodeConfig().setId(this.id).setAddress(this.address);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.address);
    }

    public boolean equals(Object object) {
        if (object instanceof Node) {
            Node member = (Node)object;
            return member.id().equals(this.id()) && member.address().equals((Object)this.address());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(Node.class).add("id", (Object)this.id).add("address", (Object)this.address).omitNullValues().toString();
    }
}

