/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.impl;

import com.google.common.base.Preconditions;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class PhiAccrualFailureDetector {
    private static final int DEFAULT_WINDOW_SIZE = 250;
    private static final int DEFAULT_MIN_SAMPLES = 25;
    private static final double DEFAULT_PHI_FACTOR = 1.0 / Math.log(10.0);
    private final int minSamples;
    private final double phiFactor;
    private final History history;

    public PhiAccrualFailureDetector() {
        this(25, DEFAULT_PHI_FACTOR, 250);
    }

    public PhiAccrualFailureDetector(int minSamples, double phiFactor) {
        this(minSamples, phiFactor, 250);
    }

    public PhiAccrualFailureDetector(int minSamples, double phiFactor, int windowSize) {
        this.minSamples = minSamples;
        this.phiFactor = phiFactor;
        this.history = new History(windowSize);
    }

    public long lastUpdated() {
        return this.history.latestHeartbeatTime();
    }

    public void report() {
        this.report(System.currentTimeMillis());
    }

    public void report(long arrivalTime) {
        Preconditions.checkArgument((arrivalTime >= 0L ? 1 : 0) != 0, (Object)"arrivalTime must not be negative");
        long latestHeartbeat = this.history.latestHeartbeatTime();
        this.history.samples().addValue((double)(arrivalTime - latestHeartbeat));
        this.history.setLatestHeartbeatTime(arrivalTime);
    }

    public double phi() {
        long latestHeartbeat = this.history.latestHeartbeatTime();
        DescriptiveStatistics samples = this.history.samples();
        if (samples.getN() < (long)this.minSamples) {
            return 0.0;
        }
        return this.computePhi(samples, latestHeartbeat, System.currentTimeMillis());
    }

    private double computePhi(DescriptiveStatistics samples, long lastHeartbeat, long currentTime) {
        long size = samples.getN();
        long t = currentTime - lastHeartbeat;
        return size > 0L ? this.phiFactor * (double)t / samples.getMean() : 100.0;
    }

    private static final class History {
        long lastHeartbeatTime = System.currentTimeMillis();
        private final DescriptiveStatistics samples;

        private History(int windowSize) {
            this.samples = new DescriptiveStatistics(windowSize);
        }

        DescriptiveStatistics samples() {
            return this.samples;
        }

        long latestHeartbeatTime() {
            return this.lastHeartbeatTime;
        }

        void setLatestHeartbeatTime(long value) {
            this.lastHeartbeatTime = value;
        }
    }
}

