/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.ManagedClusterCommunicationService;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.UnicastService;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.net.Address;
import java.net.ConnectException;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterCommunicationService
implements ManagedClusterCommunicationService {
    protected final ClusterMembershipService membershipService;
    protected final MessagingService messagingService;
    protected final UnicastService unicastService;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, BiConsumer<Address, byte[]>> unicastConsumers = Maps.newConcurrentMap();
    private final AtomicBoolean started = new AtomicBoolean();

    public DefaultClusterCommunicationService(ClusterMembershipService membershipService, MessagingService messagingService, UnicastService unicastService) {
        this.membershipService = (ClusterMembershipService)Preconditions.checkNotNull((Object)membershipService, (Object)"clusterService cannot be null");
        this.messagingService = (MessagingService)Preconditions.checkNotNull((Object)messagingService, (Object)"messagingService cannot be null");
        this.unicastService = (UnicastService)Preconditions.checkNotNull((Object)unicastService, (Object)"unicastService cannot be null");
    }

    @Override
    public <M> void broadcast(String subject, M message, Function<M, byte[]> encoder, boolean reliable) {
        this.multicast(subject, message, encoder, this.membershipService.getMembers().stream().filter(node -> !Objects.equal((Object)node, (Object)this.membershipService.getLocalMember())).map(Member::id).collect(Collectors.toSet()), reliable);
    }

    @Override
    public <M> void broadcastIncludeSelf(String subject, M message, Function<M, byte[]> encoder, boolean reliable) {
        this.multicast(subject, message, encoder, this.membershipService.getMembers().stream().map(Member::id).collect(Collectors.toSet()), reliable);
    }

    @Override
    public <M> CompletableFuture<Void> unicast(String subject, M message, Function<M, byte[]> encoder, MemberId toMemberId, boolean reliable) {
        try {
            return this.doUnicast(subject, encoder.apply(message), toMemberId, reliable);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public <M> void multicast(String subject, M message, Function<M, byte[]> encoder, Set<MemberId> nodes, boolean reliable) {
        byte[] payload = encoder.apply(message);
        nodes.forEach(memberId -> this.doUnicast(subject, payload, (MemberId)memberId, reliable));
    }

    @Override
    public <M, R> CompletableFuture<R> send(String subject, M message, Function<M, byte[]> encoder, Function<byte[], R> decoder, MemberId toMemberId, Duration timeout) {
        try {
            return this.sendAndReceive(subject, encoder.apply(message), toMemberId, timeout).thenApply(decoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public <M, R> CompletableFuture<Void> subscribe(String subject, Function<byte[], M> decoder, Function<M, R> handler, Function<R, byte[]> encoder, Executor executor) {
        this.messagingService.registerHandler(subject, new InternalMessageResponder<Object, R>(decoder, encoder, m -> {
            CompletableFuture responseFuture = new CompletableFuture();
            executor.execute(() -> {
                try {
                    responseFuture.complete(handler.apply(m));
                }
                catch (Exception e) {
                    responseFuture.completeExceptionally(e);
                }
            });
            return responseFuture;
        }));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public <M, R> CompletableFuture<Void> subscribe(String subject, Function<byte[], M> decoder, Function<M, CompletableFuture<R>> handler, Function<R, byte[]> encoder) {
        this.messagingService.registerHandler(subject, new InternalMessageResponder<M, R>(decoder, encoder, handler));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public <M> CompletableFuture<Void> subscribe(String subject, Function<byte[], M> decoder, Consumer<M> handler, Executor executor) {
        this.messagingService.registerHandler(subject, new InternalMessageConsumer<M>(decoder, handler), executor);
        InternalMessageConsumer<M> unicastConsumer = new InternalMessageConsumer<M>(decoder, handler);
        this.unicastConsumers.put(subject, unicastConsumer);
        this.unicastService.addListener(subject, unicastConsumer, executor);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public <M> CompletableFuture<Void> subscribe(String subject, Function<byte[], M> decoder, BiConsumer<MemberId, M> handler, Executor executor) {
        this.messagingService.registerHandler(subject, new InternalMessageBiConsumer<M>(decoder, handler), executor);
        InternalMessageBiConsumer<M> unicastConsumer = new InternalMessageBiConsumer<M>(decoder, handler);
        this.unicastConsumers.put(subject, unicastConsumer);
        this.unicastService.addListener(subject, unicastConsumer, executor);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void unsubscribe(String subject) {
        this.messagingService.unregisterHandler(subject);
        BiConsumer<Address, byte[]> consumer = this.unicastConsumers.remove(subject);
        if (consumer != null) {
            this.unicastService.removeListener(subject, consumer);
        }
    }

    private CompletableFuture<Void> doUnicast(String subject, byte[] payload, MemberId toMemberId, boolean reliable) {
        Member member = this.membershipService.getMember(toMemberId);
        if (member == null) {
            return this.failOnMemberNotKnown(subject, toMemberId);
        }
        if (reliable) {
            return this.messagingService.sendAsync(member.address(), subject, payload);
        }
        this.unicastService.unicast(member.address(), subject, payload);
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<byte[]> sendAndReceive(String subject, byte[] payload, MemberId toMemberId, Duration timeout) {
        Member member = this.membershipService.getMember(toMemberId);
        if (member == null) {
            return this.failOnMemberNotKnown(subject, toMemberId);
        }
        return this.messagingService.sendAndReceive(member.address(), subject, payload, timeout);
    }

    private <T> CompletableFuture<T> failOnMemberNotKnown(String subject, MemberId toMemberId) {
        String errorMessage = String.format("Expected to send a message with subject '%s' to member '%s', but member is not known. Known members are '%s'.", subject, toMemberId, this.membershipService.getMembers());
        return Futures.exceptionalFuture((Throwable)new ConnectException(errorMessage));
    }

    public CompletableFuture<ClusterCommunicationService> start() {
        if (this.started.compareAndSet(false, true)) {
            this.log.info("Started");
        }
        return CompletableFuture.completedFuture(this);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        if (this.started.compareAndSet(true, false)) {
            this.log.info("Stopped");
        }
        return CompletableFuture.completedFuture(null);
    }

    private class InternalMessageBiConsumer<M>
    implements BiConsumer<Address, byte[]> {
        private final Function<byte[], M> decoder;
        private final BiConsumer<MemberId, M> consumer;

        InternalMessageBiConsumer(Function<byte[], M> decoder, BiConsumer<MemberId, M> consumer) {
            this.decoder = decoder;
            this.consumer = consumer;
        }

        @Override
        public void accept(Address sender, byte[] bytes) {
            Member member = DefaultClusterCommunicationService.this.membershipService.getMember(sender);
            if (member != null) {
                this.consumer.accept(member.id(), this.decoder.apply(bytes));
            }
        }
    }

    private static class InternalMessageConsumer<M>
    implements BiConsumer<Address, byte[]> {
        private final Function<byte[], M> decoder;
        private final Consumer<M> consumer;

        InternalMessageConsumer(Function<byte[], M> decoder, Consumer<M> consumer) {
            this.decoder = decoder;
            this.consumer = consumer;
        }

        @Override
        public void accept(Address sender, byte[] bytes) {
            this.consumer.accept(this.decoder.apply(bytes));
        }
    }

    private static class InternalMessageResponder<M, R>
    implements BiFunction<Address, byte[], CompletableFuture<byte[]>> {
        private final Function<byte[], M> decoder;
        private final Function<R, byte[]> encoder;
        private final Function<M, CompletableFuture<R>> handler;

        InternalMessageResponder(Function<byte[], M> decoder, Function<R, byte[]> encoder, Function<M, CompletableFuture<R>> handler) {
            this.decoder = decoder;
            this.encoder = encoder;
            this.handler = handler;
        }

        @Override
        public CompletableFuture<byte[]> apply(Address sender, byte[] bytes) {
            return this.handler.apply(this.decoder.apply(bytes)).thenApply(this.encoder);
        }
    }
}

