/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.partition;

import com.esotericsoftware.kryo.serializers.FieldSerializer;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.raft.partition.RaftPartitionGroup;
import io.atomix.raft.partition.RaftStorageConfig;
import io.atomix.raft.zeebe.EntryValidator;
import io.atomix.raft.zeebe.NoopEntryValidator;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;

public class RaftPartitionGroupConfig
extends PartitionGroupConfig<RaftPartitionGroupConfig> {
    private static final int DEFAULT_PARTITIONS = 7;
    private static final Duration DEFAULT_ELECTION_TIMEOUT = Duration.ofMillis(2500L);
    private static final Duration DEFAULT_HEARTBEAT_INTERVAL = Duration.ofMillis(250L);
    private Set<String> members = new HashSet<String>();
    private int partitionSize;
    private Duration electionTimeout = DEFAULT_ELECTION_TIMEOUT;
    private Duration heartbeatInterval = DEFAULT_HEARTBEAT_INTERVAL;
    private RaftStorageConfig storageConfig = new RaftStorageConfig();
    private int maxAppendsPerFollower = 2;
    private int maxAppendBatchSize = 32768;
    @FieldSerializer.Optional(value="EntryValidator")
    private EntryValidator entryValidator = new NoopEntryValidator();

    @Override
    protected int getDefaultPartitions() {
        return 7;
    }

    public Duration getElectionTimeout() {
        return this.electionTimeout;
    }

    public RaftPartitionGroupConfig setElectionTimeout(Duration electionTimeout) {
        this.electionTimeout = electionTimeout;
        return this;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public RaftPartitionGroupConfig setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    public Set<String> getMembers() {
        return this.members;
    }

    public RaftPartitionGroupConfig setMembers(Set<String> members) {
        this.members = members;
        return this;
    }

    public int getPartitionSize() {
        return this.partitionSize;
    }

    public RaftPartitionGroupConfig setPartitionSize(int partitionSize) {
        this.partitionSize = partitionSize;
        return this;
    }

    public RaftStorageConfig getStorageConfig() {
        return this.storageConfig;
    }

    public RaftPartitionGroupConfig setStorageConfig(RaftStorageConfig storageConfig) {
        this.storageConfig = storageConfig;
        return this;
    }

    public EntryValidator getEntryValidator() {
        return this.entryValidator;
    }

    public RaftPartitionGroupConfig setEntryValidator(EntryValidator entryValidator) {
        this.entryValidator = entryValidator;
        return this;
    }

    public int getMaxAppendsPerFollower() {
        return this.maxAppendsPerFollower;
    }

    public void setMaxAppendsPerFollower(int maxAppendsPerFollower) {
        this.maxAppendsPerFollower = maxAppendsPerFollower;
    }

    public int getMaxAppendBatchSize() {
        return this.maxAppendBatchSize;
    }

    public void setMaxAppendBatchSize(int maxAppendBatchSize) {
        this.maxAppendBatchSize = maxAppendBatchSize;
    }

    public PartitionGroup.Type getType() {
        return RaftPartitionGroup.TYPE;
    }
}

