/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.roles;

import io.atomix.raft.RaftError;
import io.atomix.raft.RaftServer;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.metrics.SnapshotReplicationMetrics;
import io.atomix.raft.protocol.AppendRequest;
import io.atomix.raft.protocol.AppendResponse;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.InstallResponse;
import io.atomix.raft.protocol.PollRequest;
import io.atomix.raft.protocol.PollResponse;
import io.atomix.raft.protocol.RaftResponse;
import io.atomix.raft.protocol.ReconfigureRequest;
import io.atomix.raft.protocol.ReconfigureResponse;
import io.atomix.raft.protocol.VoteRequest;
import io.atomix.raft.protocol.VoteResponse;
import io.atomix.raft.roles.InactiveRole;
import io.atomix.raft.roles.RaftRole;
import io.atomix.raft.snapshot.impl.SnapshotChunkImpl;
import io.atomix.raft.storage.log.IndexedRaftRecord;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.atomix.storage.StorageException;
import io.atomix.utils.concurrent.ThreadContext;
import io.zeebe.snapshots.raft.PersistedSnapshot;
import io.zeebe.snapshots.raft.PersistedSnapshotListener;
import io.zeebe.snapshots.raft.ReceivedSnapshot;
import io.zeebe.snapshots.raft.SnapshotChunk;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class PassiveRole
extends InactiveRole {
    private final SnapshotReplicationMetrics snapshotReplicationMetrics;
    private long pendingSnapshotStartTimestamp;
    private ReceivedSnapshot pendingSnapshot;
    private PersistedSnapshotListener snapshotListener;
    private ByteBuffer nextPendingSnapshotChunkId;

    public PassiveRole(RaftContext context) {
        super(context);
        this.snapshotReplicationMetrics = new SnapshotReplicationMetrics(context.getName());
        this.snapshotReplicationMetrics.setCount(0);
    }

    @Override
    public CompletableFuture<RaftRole> start() {
        this.snapshotListener = this.createSnapshotListener();
        return ((CompletableFuture)((CompletableFuture)super.start().thenRun(this::truncateUncommittedEntries)).thenRun(this::addSnapshotListener)).thenApply(v -> this);
    }

    @Override
    public CompletableFuture<Void> stop() {
        this.abortPendingSnapshots();
        if (this.snapshotListener != null) {
            this.raft.getPersistedSnapshotStore().removeSnapshotListener(this.snapshotListener);
        }
        try {
            this.raft.getPersistedSnapshotStore().purgePendingSnapshots().join();
        }
        catch (Exception e) {
            this.log.warn("Failed to purge pending snapshots, which may result in unnecessary disk usage and should be monitored", (Throwable)e);
        }
        return super.stop();
    }

    private void truncateUncommittedEntries() {
        PersistedSnapshot latestSnapshot;
        if (this.role() == RaftServer.Role.PASSIVE) {
            this.raft.getLog().truncate(this.raft.getCommitIndex());
        }
        if ((latestSnapshot = this.raft.getCurrentSnapshot()) != null && this.snapshotListener != null) {
            this.snapshotListener.onNewSnapshot(latestSnapshot);
        }
    }

    protected PersistedSnapshotListener createSnapshotListener() {
        return new ResetWriterSnapshotListener(this.log, this.raft.getThreadContext(), this.raft.getLog());
    }

    private void addSnapshotListener() {
        if (this.snapshotListener != null) {
            this.raft.getPersistedSnapshotStore().addSnapshotListener(this.snapshotListener);
        }
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.PASSIVE;
    }

    @Override
    public CompletableFuture<InstallResponse> onInstall(InstallRequest request) {
        boolean snapshotChunkConsumptionFailed;
        long latestIndex;
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.currentTerm(), request.leader());
        this.log.debug("Received snapshot {} chunk from {}", (Object)request.index(), (Object)request.leader());
        if (request.currentTerm() < this.raft.getTerm()) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request term is less than the local term " + request.currentTerm())).build()));
        }
        if (this.raft.getCommitIndex() > request.index()) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
        }
        if (this.pendingSnapshot != null && request.index() != this.pendingSnapshot.index()) {
            this.abortPendingSnapshots();
        }
        if ((latestIndex = this.raft.getCurrentSnapshotIndex()) >= request.index()) {
            this.abortPendingSnapshots();
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
        }
        if (!request.complete() && request.nextChunkId() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR, "Snapshot installation is not complete but did not provide any next expected chunk")).build()));
        }
        SnapshotChunkImpl snapshotChunk = new SnapshotChunkImpl();
        UnsafeBuffer snapshotChunkBuffer = new UnsafeBuffer(request.data());
        if (!snapshotChunk.tryWrap((DirectBuffer)snapshotChunkBuffer)) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.APPLICATION_ERROR, "Failed to parse request data")).build()));
        }
        if (this.pendingSnapshot == null) {
            if (!request.isInitial()) {
                return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request chunk offset is invalid")).build()));
            }
            this.pendingSnapshot = this.raft.getPersistedSnapshotStore().newReceivedSnapshot(snapshotChunk.getSnapshotId());
            this.log.info("Started receiving new snapshot {} from {}", (Object)this.pendingSnapshot, (Object)request.leader());
            this.pendingSnapshotStartTimestamp = System.currentTimeMillis();
            this.snapshotReplicationMetrics.incrementCount();
        } else if (!this.isExpectedChunk(request.chunkId())) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request chunk is was received out of order")).build()));
        }
        try {
            snapshotChunkConsumptionFailed = (Boolean)this.pendingSnapshot.apply((SnapshotChunk)snapshotChunk).join() == false;
        }
        catch (Exception e) {
            this.log.error("Failed to write pending snapshot chunk {}, rolling back", (Object)this.pendingSnapshot, (Object)e);
            snapshotChunkConsumptionFailed = true;
        }
        if (snapshotChunkConsumptionFailed) {
            this.abortPendingSnapshots();
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.APPLICATION_ERROR, "Failed to write pending snapshot chunk")).build()));
        }
        if (request.complete()) {
            long elapsed = System.currentTimeMillis() - this.pendingSnapshotStartTimestamp;
            this.log.debug("Committing snapshot {}", (Object)this.pendingSnapshot);
            try {
                PersistedSnapshot snapshot = (PersistedSnapshot)this.pendingSnapshot.persist().join();
                this.log.info("Committed snapshot {}", (Object)snapshot);
                this.snapshotListener.onNewSnapshot(snapshot);
            }
            catch (Exception e) {
                this.log.error("Failed to commit pending snapshot {}, rolling back", (Object)this.pendingSnapshot, (Object)e);
                this.abortPendingSnapshots();
                return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.APPLICATION_ERROR, "Failed to commit pending snapshot")).build()));
            }
            this.pendingSnapshot = null;
            this.pendingSnapshotStartTimestamp = 0L;
            this.snapshotReplicationMetrics.decrementCount();
            this.snapshotReplicationMetrics.observeDuration(elapsed);
        } else {
            this.setNextExpected(request.nextChunkId());
        }
        return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
    }

    @Override
    public CompletableFuture<ReconfigureResponse> onReconfigure(ReconfigureRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::reconfigure).exceptionally(error -> ((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        return this.handleAppend(request);
    }

    @Override
    public CompletableFuture<PollResponse> onPoll(PollRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(((PollResponse.Builder)((PollResponse.Builder)PollResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Cannot poll RESERVE member")).build()));
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), null);
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Cannot request vote from RESERVE member")).build()));
    }

    private void setNextExpected(ByteBuffer nextChunkId) {
        this.nextPendingSnapshotChunkId = nextChunkId;
    }

    private boolean isExpectedChunk(ByteBuffer chunkId) {
        return this.nextPendingSnapshotChunkId == null || this.nextPendingSnapshotChunkId.equals(chunkId);
    }

    private void abortPendingSnapshots() {
        this.setNextExpected(null);
        if (this.pendingSnapshot != null) {
            this.log.info("Rolling back snapshot {}", (Object)this.pendingSnapshot);
            try {
                this.pendingSnapshot.abort();
            }
            catch (Exception e) {
                this.log.error("Failed to abort pending snapshot, clearing status anyway", (Throwable)e);
            }
            this.pendingSnapshot = null;
            this.pendingSnapshotStartTimestamp = 0L;
            this.snapshotReplicationMetrics.decrementCount();
        }
    }

    protected CompletableFuture<AppendResponse> handleAppend(AppendRequest request) {
        CompletableFuture<AppendResponse> future = new CompletableFuture<AppendResponse>();
        if (!this.checkTerm(request, future)) {
            return future;
        }
        if (!this.checkPreviousEntry(request, future)) {
            return future;
        }
        if (!this.checkChecksums(request, future)) {
            return future;
        }
        this.appendEntries(request, future);
        return future;
    }

    private boolean checkChecksums(AppendRequest request, CompletableFuture<AppendResponse> future) {
        if (request.checksums() != null && request.entries().size() != request.checksums().size()) {
            this.log.debug("Rejected {}: expected the same number of checksums as entries", (Object)request);
            return this.failAppend(this.raft.getLog().getLastIndex(), future);
        }
        return true;
    }

    protected boolean checkTerm(AppendRequest request, CompletableFuture<AppendResponse> future) {
        if (request.term() < this.raft.getTerm()) {
            this.log.debug("Rejected {}: request term is less than the current term ({})", (Object)request, (Object)this.raft.getTerm());
            return this.failAppend(this.raft.getLog().getLastIndex(), future);
        }
        return true;
    }

    protected boolean checkPreviousEntry(AppendRequest request, CompletableFuture<AppendResponse> future) {
        if (request.prevLogTerm() != 0L) {
            IndexedRaftRecord lastEntry = this.raft.getLog().getLastEntry();
            if (lastEntry != null) {
                return this.checkPreviousEntry(request, lastEntry.index(), lastEntry.entry().term(), future);
            }
            PersistedSnapshot currentSnapshot = this.raft.getCurrentSnapshot();
            if (currentSnapshot != null) {
                return this.checkPreviousEntry(request, currentSnapshot.getIndex(), currentSnapshot.getTerm(), future);
            }
            if (request.prevLogIndex() > 0L) {
                this.log.debug("Rejected {}: Previous index ({}) is greater than the local log's last index (0)", (Object)request, (Object)request.prevLogIndex());
                return this.failAppend(0L, future);
            }
        }
        return true;
    }

    private boolean checkPreviousEntry(AppendRequest request, long lastEntryIndex, long lastEntryTerm, CompletableFuture<AppendResponse> future) {
        RaftLogReader reader = this.raft.getLogReader();
        if (request.prevLogIndex() > lastEntryIndex) {
            this.log.debug("Rejected {}: Previous index ({}) is greater than the local log's last index ({})", new Object[]{request, request.prevLogIndex(), lastEntryIndex});
            return this.failAppend(lastEntryIndex, future);
        }
        if (request.prevLogIndex() < lastEntryIndex) {
            reader.reset(request.prevLogIndex());
            if (!reader.hasNext()) {
                this.log.debug("Rejected {}: Previous entry does not exist in the local log", (Object)request);
                return this.failAppend(lastEntryIndex, future);
            }
            IndexedRaftRecord previousEntry = reader.next();
            if (request.prevLogTerm() != previousEntry.entry().term()) {
                this.log.debug("Rejected {}: Previous entry term ({}) does not match local log's term for the same entry ({})", new Object[]{request, request.prevLogTerm(), previousEntry.entry().term()});
                return this.failAppend(request.prevLogIndex() - 1L, future);
            }
        } else if (request.prevLogTerm() != lastEntryTerm) {
            this.log.debug("Rejected {}: Previous entry term ({}) does not equal the local log's last term ({})", new Object[]{request, request.prevLogTerm(), lastEntryTerm});
            return this.failAppend(request.prevLogIndex() - 1L, future);
        }
        return true;
    }

    protected void appendEntries(AppendRequest request, CompletableFuture<AppendResponse> future) {
        long lastEntryIndex = request.prevLogIndex() + (long)request.entries().size();
        long commitIndex = Math.max(this.raft.getCommitIndex(), Math.min(request.commitIndex(), lastEntryIndex));
        long lastLogIndex = request.prevLogIndex();
        if (!request.entries().isEmpty()) {
            RaftLogReader reader = this.raft.getLogReader();
            if (request.prevLogTerm() == 0L) {
                this.log.debug("Reset first index to {}", (Object)(request.prevLogIndex() + 1L));
                this.raft.getLog().reset(request.prevLogIndex() + 1L);
            }
            for (int i = 0; i < request.entries().size(); ++i) {
                long index = ++lastLogIndex;
                RaftLogEntry entry = request.entries().get(i);
                Long checksum = request.checksums() == null ? null : request.checksums().get(i);
                IndexedRaftRecord lastEntry = this.raft.getLog().getLastEntry();
                boolean failedToAppend = this.tryToAppend(future, reader, entry, index, lastEntry);
                if (failedToAppend) {
                    return;
                }
                if (!this.role().active() && index == commitIndex) break;
            }
        }
        this.raft.setFirstCommitIndex(request.commitIndex());
        long previousCommitIndex = this.raft.setCommitIndex(commitIndex);
        if (previousCommitIndex < commitIndex) {
            this.log.trace("Committed entries up to index {}", (Object)commitIndex);
            this.raft.notifyCommitListeners(commitIndex);
        }
        if (this.raft.getLog().shouldFlushExplicitly()) {
            this.raft.getLog().flush();
        }
        this.succeedAppend(lastLogIndex, future);
    }

    private boolean tryToAppend(CompletableFuture<AppendResponse> future, RaftLogReader reader, RaftLogEntry entry, long index, IndexedRaftRecord lastEntry) {
        boolean failedToAppend = false;
        if (lastEntry != null) {
            if (lastEntry.index() > index) {
                failedToAppend = !this.replaceExistingEntry(future, reader, entry, index);
            } else if (lastEntry.index() == index) {
                if (lastEntry.entry().term() != entry.term()) {
                    this.raft.getLog().truncate(index - 1L);
                    failedToAppend = !this.appendEntry(index, entry, future);
                }
            } else {
                failedToAppend = !this.appendEntry(future, entry, index, lastEntry);
            }
        } else {
            failedToAppend = !this.appendEntry(index, entry, future);
        }
        return failedToAppend;
    }

    private boolean appendEntry(CompletableFuture<AppendResponse> future, RaftLogEntry entry, long index, IndexedRaftRecord lastEntry) {
        if (lastEntry.index() != index - 1L) {
            throw new IllegalStateException("Log writer inconsistent with next append entry index " + index);
        }
        return this.appendEntry(index, entry, future);
    }

    private boolean replaceExistingEntry(CompletableFuture<AppendResponse> future, RaftLogReader reader, RaftLogEntry entry, long index) {
        reader.reset(index);
        if (!reader.hasNext()) {
            throw new IllegalStateException("Log reader inconsistent with log writer");
        }
        IndexedRaftRecord existingEntry = reader.next();
        if (existingEntry.entry().term() != entry.term()) {
            this.raft.getLog().truncate(index - 1L);
            if (!this.appendEntry(index, entry, future)) {
                return false;
            }
        }
        return true;
    }

    private boolean appendEntry(long index, RaftLogEntry entry, CompletableFuture<AppendResponse> future) {
        try {
            IndexedRaftRecord indexed = this.raft.getLog().append(entry);
            this.log.trace("Appended {}", (Object)indexed);
            this.raft.getReplicationMetrics().setAppendIndex(indexed.index());
        }
        catch (StorageException.TooLarge e) {
            this.log.warn("Entry size exceeds maximum allowed bytes. Ensure Raft storage configuration is consistent on all nodes!");
            return false;
        }
        catch (StorageException.OutOfDiskSpace e) {
            this.log.trace("Append failed: ", (Throwable)e);
            this.raft.getLogCompactor().compact();
            this.failAppend(index - 1L, future);
            return false;
        }
        catch (StorageException.InvalidChecksum e) {
            this.log.debug("Entry checksum doesn't match entry data: ", (Throwable)e);
            this.failAppend(index - 1L, future);
            return false;
        }
        return true;
    }

    protected boolean failAppend(long lastLogIndex, CompletableFuture<AppendResponse> future) {
        return this.completeAppend(false, lastLogIndex, future);
    }

    protected boolean succeedAppend(long lastLogIndex, CompletableFuture<AppendResponse> future) {
        return this.completeAppend(true, lastLogIndex, future);
    }

    protected boolean completeAppend(boolean succeeded, long lastLogIndex, CompletableFuture<AppendResponse> future) {
        future.complete(this.logResponse(((AppendResponse.Builder)AppendResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withSucceeded(succeeded).withLastLogIndex(lastLogIndex).withLastSnapshotIndex(this.raft.getCurrentSnapshotIndex()).build()));
        return succeeded;
    }

    private static final class ResetWriterSnapshotListener
    implements PersistedSnapshotListener {
        private final ThreadContext threadContext;
        private final RaftLog raftLog;
        private final Logger log;

        ResetWriterSnapshotListener(Logger log, ThreadContext threadContext, RaftLog raftLog) {
            this.log = log;
            this.threadContext = threadContext;
            this.raftLog = raftLog;
        }

        public void onNewSnapshot(PersistedSnapshot persistedSnapshot) {
            if (this.threadContext.isCurrentContext()) {
                long index = persistedSnapshot.getIndex();
                long lastIndex = this.raftLog.getLastIndex();
                if (lastIndex < index) {
                    this.log.info("Delete existing log (lastIndex '{}') and replace with received snapshot (index '{}')", (Object)lastIndex, (Object)index);
                    this.raftLog.reset(index + 1L);
                }
            } else {
                this.threadContext.execute(() -> this.onNewSnapshot(persistedSnapshot));
            }
        }
    }
}

