/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.system.MetaStore;
import io.atomix.storage.StorageException;
import io.atomix.storage.buffer.FileBuffer;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import io.zeebe.snapshots.raft.ReceivableSnapshotStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.function.Predicate;
import org.agrona.IoUtil;

public final class RaftStorage {
    private final String prefix;
    private final File directory;
    private final Namespace namespace;
    private final int maxSegmentSize;
    private final int maxEntrySize;
    private final long freeDiskSpace;
    private final boolean flushExplicitly;
    private final ReceivableSnapshotStore persistedSnapshotStore;
    private final int journalIndexDensity;

    private RaftStorage(String prefix, File directory, Namespace namespace, int maxSegmentSize, int maxEntrySize, long freeDiskSpace, boolean flushExplicitly, ReceivableSnapshotStore persistedSnapshotStore, int journalIndexDensity) {
        this.prefix = prefix;
        this.directory = directory;
        this.namespace = namespace;
        this.maxSegmentSize = maxSegmentSize;
        this.maxEntrySize = maxEntrySize;
        this.freeDiskSpace = freeDiskSpace;
        this.flushExplicitly = flushExplicitly;
        this.persistedSnapshotStore = persistedSnapshotStore;
        this.journalIndexDensity = journalIndexDensity;
        IoUtil.ensureDirectoryExists((File)directory, (String)(prefix + " raft partition storage"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public String prefix() {
        return this.prefix;
    }

    public Namespace namespace() {
        return this.namespace;
    }

    public int maxLogSegmentSize() {
        return this.maxSegmentSize;
    }

    public long freeDiskSpace() {
        return this.freeDiskSpace;
    }

    public boolean lock(String id) {
        boolean bl;
        block16: {
            File file = new File(this.directory, String.format(".%s.lock", this.prefix));
            if (file.createNewFile()) {
                try (FileBuffer buffer = FileBuffer.allocate((File)file);){
                    buffer.writeString(id).flush();
                }
                return true;
            }
            FileBuffer buffer = FileBuffer.allocate((File)file);
            try {
                String lock = buffer.readString();
                boolean bl2 = bl = lock != null && lock.equals(id);
                if (buffer == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (buffer != null) {
                        try {
                            buffer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StorageException("Failed to acquire storage lock");
                }
            }
            buffer.close();
        }
        return bl;
    }

    public void unlock() {
        this.deleteFiles(f -> f.getName().equals(String.format(".%s.lock", this.prefix)));
    }

    private void deleteFiles(Predicate<File> predicate) {
        this.directory.mkdirs();
        for (File file : this.directory.listFiles(f -> f.isFile() && predicate.test(f))) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public MetaStore openMetaStore() {
        return new MetaStore(this, Serializer.using((Namespace)this.namespace));
    }

    public void deleteMetaStore() {
        this.deleteFiles(f -> f.getName().equals(String.format("%s.meta", this.prefix)) || f.getName().equals(String.format("%s.conf", this.prefix)));
    }

    public ReceivableSnapshotStore getPersistedSnapshotStore() {
        return this.persistedSnapshotStore;
    }

    public void deleteSnapshotStore() {
        this.persistedSnapshotStore.delete();
    }

    public RaftLog openLog() {
        return RaftLog.builder().withName(this.prefix).withDirectory(this.directory).withNamespace(this.namespace).withMaxSegmentSize(this.maxSegmentSize).withMaxEntrySize(this.maxEntrySize).withFreeDiskSpace(this.freeDiskSpace).withFlushExplicitly(this.flushExplicitly).withJournalIndexDensity(this.journalIndexDensity).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("directory", (Object)this.directory()).toString();
    }

    public File directory() {
        return this.directory;
    }

    public boolean isFlushExplicitly() {
        return this.flushExplicitly;
    }

    public static final class Builder
    implements io.atomix.utils.Builder<RaftStorage> {
        private static final String DEFAULT_PREFIX = "atomix";
        private static final String DEFAULT_DIRECTORY = System.getProperty("atomix.data", System.getProperty("user.dir"));
        private static final int DEFAULT_MAX_SEGMENT_SIZE = 0x2000000;
        private static final int DEFAULT_MAX_ENTRY_SIZE = 0x100000;
        private static final long DEFAULT_FREE_DISK_SPACE = 0x40000000L;
        private static final boolean DEFAULT_FLUSH_EXPLICITLY = true;
        private static final int DEFAULT_JOURNAL_INDEX_DENSITY = 100;
        private String prefix = "atomix";
        private File directory = new File(DEFAULT_DIRECTORY);
        private Namespace namespace;
        private int maxSegmentSize = 0x2000000;
        private int maxEntrySize = 0x100000;
        private long freeDiskSpace = 0x40000000L;
        private boolean flushExplicitly = true;
        private ReceivableSnapshotStore persistedSnapshotStore;
        private int journalIndexDensity = 100;

        private Builder() {
        }

        public Builder withPrefix(String prefix) {
            this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix cannot be null");
            return this;
        }

        public Builder withDirectory(String directory) {
            return this.withDirectory(new File((String)Preconditions.checkNotNull((Object)directory, (Object)"directory")));
        }

        public Builder withDirectory(File directory) {
            this.directory = (File)Preconditions.checkNotNull((Object)directory, (Object)"directory");
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.namespace = (Namespace)Preconditions.checkNotNull((Object)namespace, (Object)"namespace cannot be null");
            return this;
        }

        public Builder withMaxSegmentSize(int maxSegmentSize) {
            this.maxSegmentSize = maxSegmentSize;
            return this;
        }

        public Builder withMaxEntrySize(int maxEntrySize) {
            Preconditions.checkArgument((maxEntrySize > 0 ? 1 : 0) != 0, (Object)"maxEntrySize must be positive");
            this.maxEntrySize = maxEntrySize;
            return this;
        }

        public Builder withFreeDiskSpace(long freeDiskSpace) {
            Preconditions.checkArgument((freeDiskSpace >= 0L ? 1 : 0) != 0, (Object)"freeDiskSpace must be positive");
            this.freeDiskSpace = freeDiskSpace;
            return this;
        }

        public Builder withFlushExplicitly(boolean flushExplicitly) {
            this.flushExplicitly = flushExplicitly;
            return this;
        }

        public Builder withSnapshotStore(ReceivableSnapshotStore persistedSnapshotStore) {
            this.persistedSnapshotStore = persistedSnapshotStore;
            return this;
        }

        public Builder withJournalIndexDensity(int journalIndexDensity) {
            this.journalIndexDensity = journalIndexDensity;
            return this;
        }

        public RaftStorage build() {
            return new RaftStorage(this.prefix, this.directory, this.namespace, this.maxSegmentSize, this.maxEntrySize, this.freeDiskSpace, this.flushExplicitly, this.persistedSnapshotStore, this.journalIndexDensity);
        }
    }
}

