/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import com.google.common.base.MoreObjects;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import java.util.Objects;

public class IndexedRaftRecord {
    private final long index;
    private final RaftLogEntry entry;
    private final int size;
    private final long checksum;

    public IndexedRaftRecord(long index, RaftLogEntry entry, int size, long checksum) {
        this.index = index;
        this.entry = entry;
        this.size = size;
        this.checksum = checksum;
    }

    public long index() {
        return this.index;
    }

    public RaftLogEntry entry() {
        return this.entry;
    }

    public int size() {
        return this.size;
    }

    public long checksum() {
        return this.checksum;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.entry, this.size);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedRaftRecord indexed = (IndexedRaftRecord)o;
        return this.index == indexed.index && this.size == indexed.size && Objects.equals(this.entry, indexed.entry) && this.checksum == indexed.checksum;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", this.index).add("entry", (Object)this.entry).add("checksum", this.checksum).toString();
    }
}

