/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.raft.storage.log.IndexedRaftRecord;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.zeebe.journal.JournalReader;
import io.zeebe.journal.JournalRecord;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;

public class RaftLogReader
implements Iterator<IndexedRaftRecord>,
AutoCloseable {
    private final RaftLog log;
    private final JournalReader journalReader;
    private final Mode mode;
    private long nextIndex;

    RaftLogReader(RaftLog log, JournalReader journalReader, Mode mode) {
        this.log = log;
        this.journalReader = journalReader;
        this.mode = mode;
        this.nextIndex = log.getFirstIndex();
    }

    @Override
    public boolean hasNext() {
        return (this.mode == Mode.ALL || this.nextIndex <= this.log.getCommitIndex()) && this.journalReader.hasNext();
    }

    @Override
    public IndexedRaftRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        JournalRecord journalRecord = (JournalRecord)this.journalReader.next();
        RaftLogEntry entry = (RaftLogEntry)this.deserialize(journalRecord.data());
        this.nextIndex = journalRecord.index() + 1L;
        return new IndexedRaftRecord(journalRecord.index(), entry, journalRecord.data().capacity(), journalRecord.checksum());
    }

    public long reset() {
        this.nextIndex = this.journalReader.seekToFirst();
        return this.nextIndex;
    }

    public long reset(long index) {
        if (this.nextIndex == index) {
            return this.nextIndex;
        }
        long boundedIndex = index;
        if (this.mode == Mode.COMMITS) {
            long upperBoundIndex = this.log.getCommitIndex() + 1L;
            boundedIndex = Math.min(index, upperBoundIndex);
        }
        this.nextIndex = this.journalReader.seek(boundedIndex);
        return this.nextIndex;
    }

    public long seekToLast() {
        if (this.mode == Mode.ALL) {
            this.nextIndex = this.journalReader.seekToLast();
        } else {
            this.reset(this.log.getCommitIndex());
        }
        return this.nextIndex;
    }

    public long seekToAsqn(long asqn) {
        this.nextIndex = this.journalReader.seekToAsqn(asqn);
        if (this.nextIndex > this.log.getCommitIndex() && !this.log.isEmpty()) {
            throw new UnsupportedOperationException("Cannot seek to an ASQN that is not yet committed");
        }
        return this.nextIndex;
    }

    @Override
    public void close() {
        this.journalReader.close();
    }

    private <T> T deserialize(DirectBuffer buffer) {
        ByteBuffer byteBufferView = buffer.byteArray() != null ? ByteBuffer.wrap(buffer.byteArray(), buffer.wrapAdjustment(), buffer.capacity()) : buffer.byteBuffer().asReadOnlyBuffer().position(buffer.wrapAdjustment()).limit(buffer.wrapAdjustment() + buffer.capacity());
        return (T)this.log.getSerializer().deserialize(byteBufferView);
    }

    public static enum Mode {
        ALL,
        COMMITS;

    }
}

