/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log.entry;

import com.google.common.base.MoreObjects;
import io.atomix.raft.storage.log.entry.RaftEntry;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ApplicationEntry
implements RaftEntry {
    private final long lowestPosition;
    private final long highestPosition;
    private final ByteBuffer data;

    public ApplicationEntry(long lowestPosition, long highestPosition, ByteBuffer data) {
        this.lowestPosition = lowestPosition;
        this.highestPosition = highestPosition;
        this.data = data;
    }

    public long lowestPosition() {
        return this.lowestPosition;
    }

    public long highestPosition() {
        return this.highestPosition;
    }

    public ByteBuffer data() {
        return this.data;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("lowestPosition", this.lowestPosition()).add("highestPosition", this.highestPosition()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationEntry that = (ApplicationEntry)o;
        return this.lowestPosition == that.lowestPosition && this.highestPosition == that.highestPosition && this.data.equals(that.data);
    }

    public int hashCode() {
        return Objects.hash(this.lowestPosition, this.highestPosition, this.data);
    }
}

