/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log.entry;

import com.google.common.base.MoreObjects;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.storage.log.entry.RaftEntry;
import io.atomix.utils.misc.TimestampPrinter;
import java.util.Collection;
import java.util.Objects;

public class ConfigurationEntry
implements RaftEntry {
    protected final Collection<RaftMember> members;
    private final long timestamp;

    public ConfigurationEntry(long timestamp, Collection<RaftMember> members) {
        this.members = members;
        this.timestamp = timestamp;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Collection<RaftMember> members() {
        return this.members;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timestamp", (Object)new TimestampPrinter(this.timestamp)).add("members", this.members).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationEntry that = (ConfigurationEntry)o;
        return this.timestamp == that.timestamp && Objects.equals(this.members, that.members);
    }

    public int hashCode() {
        return Objects.hash(this.members, this.timestamp);
    }
}

