/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record;

import io.zeebe.protocol.record.GroupSizeEncodingDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.CompositeEncoderFlyweight;

public final class GroupSizeEncodingEncoder
implements CompositeEncoderFlyweight {
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 3;
    public static final int ENCODED_LENGTH = 3;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    public GroupSizeEncodingEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 3;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 3;
    }

    public static int blockLengthEncodingOffset() {
        return 0;
    }

    public static int blockLengthEncodingLength() {
        return 2;
    }

    public static int blockLengthNullValue() {
        return 65535;
    }

    public static int blockLengthMinValue() {
        return 0;
    }

    public static int blockLengthMaxValue() {
        return 65534;
    }

    public GroupSizeEncodingEncoder blockLength(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int numInGroupEncodingOffset() {
        return 2;
    }

    public static int numInGroupEncodingLength() {
        return 1;
    }

    public static short numInGroupNullValue() {
        return 255;
    }

    public static short numInGroupMinValue() {
        return 0;
    }

    public static short numInGroupMaxValue() {
        return 254;
    }

    public GroupSizeEncodingEncoder numInGroup(short value) {
        this.buffer.putByte(this.offset + 2, (byte)value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        GroupSizeEncodingDecoder decoder = new GroupSizeEncodingDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset);
        return decoder.appendTo(builder);
    }
}

