/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record.intent;

import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.ErrorIntent;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.JobBatchIntent;
import io.zeebe.protocol.record.intent.JobIntent;
import io.zeebe.protocol.record.intent.MessageIntent;
import io.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.protocol.record.intent.ProcessInstanceResultIntent;
import io.zeebe.protocol.record.intent.ProcessInstanceSubscriptionIntent;
import io.zeebe.protocol.record.intent.ProcessIntent;
import io.zeebe.protocol.record.intent.TimerIntent;
import io.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.zeebe.protocol.record.intent.VariableIntent;
import java.util.Arrays;
import java.util.Collection;

public interface Intent {
    public static final Collection<Class<? extends Intent>> INTENT_CLASSES = Arrays.asList(DeploymentIntent.class, IncidentIntent.class, JobIntent.class, ProcessInstanceIntent.class, MessageIntent.class, MessageSubscriptionIntent.class, ProcessInstanceSubscriptionIntent.class, JobBatchIntent.class, TimerIntent.class, VariableIntent.class, VariableDocumentIntent.class, ProcessInstanceCreationIntent.class, ErrorIntent.class, ProcessIntent.class, DeploymentDistributionIntent.class);
    public static final short NULL_VAL = 255;
    public static final Intent UNKNOWN = new Intent(){

        @Override
        public short value() {
            return 255;
        }

        @Override
        public String name() {
            return "UNKNOWN";
        }
    };

    public short value();

    public String name();

    public static Intent fromProtocolValue(ValueType valueType, short intent) {
        switch (valueType) {
            case DEPLOYMENT: {
                return DeploymentIntent.from(intent);
            }
            case INCIDENT: {
                return IncidentIntent.from(intent);
            }
            case JOB: {
                return JobIntent.from(intent);
            }
            case PROCESS_INSTANCE: {
                return ProcessInstanceIntent.from(intent);
            }
            case MESSAGE: {
                return MessageIntent.from(intent);
            }
            case MESSAGE_SUBSCRIPTION: {
                return MessageSubscriptionIntent.from(intent);
            }
            case MESSAGE_START_EVENT_SUBSCRIPTION: {
                return MessageStartEventSubscriptionIntent.from(intent);
            }
            case PROCESS_INSTANCE_SUBSCRIPTION: {
                return ProcessInstanceSubscriptionIntent.from(intent);
            }
            case JOB_BATCH: {
                return JobBatchIntent.from(intent);
            }
            case TIMER: {
                return TimerIntent.from(intent);
            }
            case VARIABLE: {
                return VariableIntent.from(intent);
            }
            case VARIABLE_DOCUMENT: {
                return VariableDocumentIntent.from(intent);
            }
            case PROCESS_INSTANCE_CREATION: {
                return ProcessInstanceCreationIntent.from(intent);
            }
            case ERROR: {
                return ErrorIntent.from(intent);
            }
            case PROCESS_INSTANCE_RESULT: {
                return ProcessInstanceResultIntent.from(intent);
            }
            case PROCESS: {
                return ProcessIntent.from(intent);
            }
            case DEPLOYMENT_DISTRIBUTION: {
                return DeploymentDistributionIntent.from(intent);
            }
            case NULL_VAL: 
            case SBE_UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new RuntimeException(String.format("Expected to map value type %s to intent type, but did not recognize the value type", valueType.name()));
    }

    public static Intent fromProtocolValue(ValueType valueType, String intent) {
        switch (valueType) {
            case DEPLOYMENT: {
                return DeploymentIntent.valueOf(intent);
            }
            case INCIDENT: {
                return IncidentIntent.valueOf(intent);
            }
            case JOB: {
                return JobIntent.valueOf(intent);
            }
            case PROCESS_INSTANCE: {
                return ProcessInstanceIntent.valueOf(intent);
            }
            case MESSAGE: {
                return MessageIntent.valueOf(intent);
            }
            case MESSAGE_SUBSCRIPTION: {
                return MessageSubscriptionIntent.valueOf(intent);
            }
            case MESSAGE_START_EVENT_SUBSCRIPTION: {
                return MessageStartEventSubscriptionIntent.valueOf(intent);
            }
            case PROCESS_INSTANCE_SUBSCRIPTION: {
                return ProcessInstanceSubscriptionIntent.valueOf(intent);
            }
            case JOB_BATCH: {
                return JobBatchIntent.valueOf(intent);
            }
            case TIMER: {
                return TimerIntent.valueOf(intent);
            }
            case VARIABLE: {
                return VariableIntent.valueOf(intent);
            }
            case VARIABLE_DOCUMENT: {
                return VariableDocumentIntent.valueOf(intent);
            }
            case PROCESS_INSTANCE_CREATION: {
                return ProcessInstanceCreationIntent.valueOf(intent);
            }
            case ERROR: {
                return ErrorIntent.valueOf(intent);
            }
            case PROCESS_INSTANCE_RESULT: {
                return ProcessInstanceResultIntent.valueOf(intent);
            }
            case PROCESS: {
                return ProcessIntent.valueOf(intent);
            }
            case DEPLOYMENT_DISTRIBUTION: {
                return DeploymentDistributionIntent.valueOf(intent);
            }
            case NULL_VAL: 
            case SBE_UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new RuntimeException(String.format("Expected to map value type %s to intent type, but did not recognize the value type", valueType.name()));
    }

    public static int maxCardinality() {
        return INTENT_CLASSES.stream().mapToInt(clazz -> ((Intent[])clazz.getEnumConstants()).length).max().getAsInt();
    }
}

