/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record.intent;

import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;
import java.util.EnumSet;
import java.util.Set;

public enum ProcessInstanceIntent implements ProcessInstanceRelatedIntent
{
    CANCEL(0, false),
    SEQUENCE_FLOW_TAKEN(1),
    ELEMENT_ACTIVATING(2),
    ELEMENT_ACTIVATED(3),
    ELEMENT_COMPLETING(4),
    ELEMENT_COMPLETED(5),
    ELEMENT_TERMINATING(6),
    ELEMENT_TERMINATED(7),
    EVENT_OCCURRED(8),
    ACTIVATE_ELEMENT(9),
    COMPLETE_ELEMENT(10),
    TERMINATE_ELEMENT(11);

    private static final Set<ProcessInstanceIntent> PROCESS_INSTANCE_COMMANDS;
    private static final Set<ProcessInstanceIntent> BPMN_ELEMENT_COMMANDS;
    private final short value;
    private final boolean shouldBlacklist;

    private ProcessInstanceIntent(short value) {
        this(value, true);
    }

    private ProcessInstanceIntent(short value, boolean shouldBlacklist) {
        this.value = value;
        this.shouldBlacklist = shouldBlacklist;
    }

    public short getIntent() {
        return this.value;
    }

    public static Intent from(short value) {
        switch (value) {
            case 0: {
                return CANCEL;
            }
            case 1: {
                return SEQUENCE_FLOW_TAKEN;
            }
            case 2: {
                return ELEMENT_ACTIVATING;
            }
            case 3: {
                return ELEMENT_ACTIVATED;
            }
            case 4: {
                return ELEMENT_COMPLETING;
            }
            case 5: {
                return ELEMENT_COMPLETED;
            }
            case 6: {
                return ELEMENT_TERMINATING;
            }
            case 7: {
                return ELEMENT_TERMINATED;
            }
            case 8: {
                return EVENT_OCCURRED;
            }
            case 9: {
                return ACTIVATE_ELEMENT;
            }
            case 10: {
                return COMPLETE_ELEMENT;
            }
            case 11: {
                return TERMINATE_ELEMENT;
            }
        }
        return Intent.UNKNOWN;
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean shouldBlacklistInstanceOnError() {
        return this.shouldBlacklist;
    }

    public static boolean isProcessInstanceCommand(ProcessInstanceIntent intent) {
        return PROCESS_INSTANCE_COMMANDS.contains(intent);
    }

    public static boolean isBpmnElementCommand(ProcessInstanceIntent intent) {
        return BPMN_ELEMENT_COMMANDS.contains(intent);
    }

    public static boolean isBpmnElementEvent(ProcessInstanceIntent intent) {
        return !ProcessInstanceIntent.isProcessInstanceCommand(intent) && !ProcessInstanceIntent.isBpmnElementCommand(intent);
    }

    static {
        PROCESS_INSTANCE_COMMANDS = EnumSet.of(CANCEL);
        BPMN_ELEMENT_COMMANDS = EnumSet.of(ACTIVATE_ELEMENT, COMPLETE_ELEMENT, TERMINATE_ELEMENT);
    }
}

