/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.db.impl.rocksdb.transaction;

import io.zeebe.db.TransactionContext;
import io.zeebe.db.TransactionOperation;
import io.zeebe.db.ZeebeDbException;
import io.zeebe.db.ZeebeDbTransaction;
import io.zeebe.db.impl.rocksdb.transaction.RocksDbInternal;
import io.zeebe.db.impl.rocksdb.transaction.ZeebeTransaction;
import io.zeebe.util.exception.RecoverableException;
import org.rocksdb.RocksDBException;
import org.rocksdb.Status;

public final class DefaultTransactionContext
implements TransactionContext {
    private final ZeebeTransaction transaction;

    DefaultTransactionContext(ZeebeTransaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public void runInTransaction(TransactionOperation operations) {
        try {
            if (this.transaction.isInCurrentTransaction()) {
                operations.run();
            } else {
                this.runInNewTransaction(operations);
            }
        }
        catch (RecoverableException recoverableException) {
            throw recoverableException;
        }
        catch (RocksDBException rdbex) {
            String errorMessage = "Unexpected error occurred during RocksDB transaction.";
            if (this.isRocksDbExceptionRecoverable(rdbex)) {
                throw new ZeebeDbException("Unexpected error occurred during RocksDB transaction.", rdbex);
            }
            throw new RuntimeException("Unexpected error occurred during RocksDB transaction.", rdbex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected error occurred during zeebe db transaction operation.", ex);
        }
    }

    @Override
    public ZeebeDbTransaction getCurrentTransaction() {
        if (!this.transaction.isInCurrentTransaction()) {
            this.transaction.resetTransaction();
        }
        return this.transaction;
    }

    private void runInNewTransaction(TransactionOperation operations) throws Exception {
        try {
            this.transaction.resetTransaction();
            operations.run();
            this.transaction.commitInternal();
        }
        finally {
            this.transaction.rollbackInternal();
        }
    }

    private boolean isRocksDbExceptionRecoverable(RocksDBException rdbex) {
        Status status = rdbex.getStatus();
        return RocksDbInternal.RECOVERABLE_ERROR_CODES.contains(status.getCode());
    }
}

