/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.db.impl.rocksdb.transaction;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.KeyValuePairVisitor;
import io.zeebe.db.TransactionContext;
import io.zeebe.db.impl.rocksdb.transaction.ColumnFamilyContext;
import io.zeebe.db.impl.rocksdb.transaction.DbNullKey;
import io.zeebe.db.impl.rocksdb.transaction.RocksDbInternal;
import io.zeebe.db.impl.rocksdb.transaction.TransactionConsumer;
import io.zeebe.db.impl.rocksdb.transaction.ZeebeTransaction;
import io.zeebe.db.impl.rocksdb.transaction.ZeebeTransactionDb;
import io.zeebe.util.buffer.BufferUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksIterator;
import org.rocksdb.RocksObject;

class TransactionalColumnFamily<ColumnFamilyNames extends Enum<ColumnFamilyNames>, KeyType extends DbKey, ValueType extends DbValue>
implements ColumnFamily<KeyType, ValueType> {
    private final ZeebeTransactionDb<ColumnFamilyNames> transactionDb;
    private final TransactionContext context;
    private final ValueType valueInstance;
    private final KeyType keyInstance;
    private final ColumnFamilyContext columnFamilyContext;

    TransactionalColumnFamily(ZeebeTransactionDb<ColumnFamilyNames> transactionDb, ColumnFamilyNames columnFamily, TransactionContext context, KeyType keyInstance, ValueType valueInstance) {
        this.transactionDb = transactionDb;
        this.context = context;
        this.keyInstance = keyInstance;
        this.valueInstance = valueInstance;
        this.columnFamilyContext = new ColumnFamilyContext(((Enum)columnFamily).ordinal());
    }

    private void ensureInOpenTransaction(TransactionContext context, TransactionConsumer operation) {
        context.runInTransaction(() -> operation.run((ZeebeTransaction)context.getCurrentTransaction()));
    }

    @Override
    public void put(KeyType key, ValueType value) {
        this.ensureInOpenTransaction(this.context, transaction -> {
            this.columnFamilyContext.writeKey((DbKey)key);
            this.columnFamilyContext.writeValue((DbValue)value);
            transaction.put(this.transactionDb.getDefaultNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength(), this.columnFamilyContext.getValueBufferArray(), value.getLength());
        });
    }

    @Override
    public ValueType get(KeyType key) {
        this.columnFamilyContext.writeKey((DbKey)key);
        DirectBuffer valueBuffer = this.getValue(this.context, this.columnFamilyContext);
        if (valueBuffer != null) {
            this.valueInstance.wrap(valueBuffer, 0, valueBuffer.capacity());
            return this.valueInstance;
        }
        return null;
    }

    private DirectBuffer getValue(TransactionContext context, ColumnFamilyContext columnFamilyContext) {
        this.ensureInOpenTransaction(context, transaction -> {
            byte[] value = transaction.get(this.transactionDb.getDefaultNativeHandle(), this.transactionDb.getReadOptionsNativeHandle(), columnFamilyContext.getKeyBufferArray(), columnFamilyContext.getKeyLength());
            columnFamilyContext.wrapValueView(value);
        });
        return columnFamilyContext.getValueView();
    }

    @Override
    public void forEach(Consumer<ValueType> consumer) {
        this.forEach(this.context, consumer);
    }

    @Override
    public void forEach(BiConsumer<KeyType, ValueType> consumer) {
        this.forEach(this.context, consumer);
    }

    @Override
    public void whileTrue(KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileTrue(this.context, visitor);
    }

    @Override
    public void whileEqualPrefix(DbKey keyPrefix, BiConsumer<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(this.context, keyPrefix, visitor);
    }

    @Override
    public void whileEqualPrefix(DbKey keyPrefix, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(this.context, keyPrefix, visitor);
    }

    @Override
    public void delete(KeyType key) {
        this.columnFamilyContext.writeKey((DbKey)key);
        this.ensureInOpenTransaction(this.context, transaction -> transaction.delete(this.transactionDb.getDefaultNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength()));
    }

    @Override
    public boolean exists(KeyType key) {
        this.columnFamilyContext.wrapValueView(new byte[0]);
        this.ensureInOpenTransaction(this.context, transaction -> {
            this.columnFamilyContext.writeKey((DbKey)key);
            this.getValue(this.context, this.columnFamilyContext);
        });
        return !this.columnFamilyContext.isValueViewEmpty();
    }

    @Override
    public boolean isEmpty() {
        AtomicBoolean isEmpty = new AtomicBoolean(true);
        this.whileEqualPrefix(this.context, this.keyInstance, this.valueInstance, (KeyType key, ValueType value) -> {
            isEmpty.set(false);
            return false;
        });
        return isEmpty.get();
    }

    public void forEach(TransactionContext context, Consumer<ValueType> consumer) {
        this.whileEqualPrefix(context, this.keyInstance, this.valueInstance, (BiConsumer<KeyType, ValueType>)((BiConsumer<DbKey, DbValue>)(ignore, value) -> consumer.accept(value)));
    }

    public void forEach(TransactionContext context, BiConsumer<KeyType, ValueType> consumer) {
        this.whileEqualPrefix(context, this.keyInstance, this.valueInstance, consumer);
    }

    public void whileTrue(TransactionContext context, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(context, this.keyInstance, this.valueInstance, visitor);
    }

    public void whileEqualPrefix(TransactionContext context, DbKey keyPrefix, BiConsumer<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(context, keyPrefix, this.keyInstance, this.valueInstance, visitor);
    }

    public void whileEqualPrefix(TransactionContext context, DbKey keyPrefix, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(context, keyPrefix, this.keyInstance, this.valueInstance, visitor);
    }

    RocksIterator newIterator(TransactionContext context, ReadOptions options) {
        ZeebeTransaction currentTransaction = (ZeebeTransaction)context.getCurrentTransaction();
        return currentTransaction.newIterator(options, this.transactionDb.getDefaultHandle());
    }

    protected <KeyType extends DbKey, ValueType extends DbValue> void whileEqualPrefix(TransactionContext context, DbKey prefix, KeyType keyInstance, ValueType valueInstance, BiConsumer<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(context, prefix, keyInstance, valueInstance, (KeyType k, ValueType v) -> {
            visitor.accept(k, v);
            return true;
        });
    }

    protected <KeyType extends DbKey, ValueType extends DbValue> void whileEqualPrefix(TransactionContext context, KeyType keyInstance, ValueType valueInstance, BiConsumer<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(context, (DbKey)new DbNullKey(), keyInstance, valueInstance, (KeyType k, ValueType v) -> {
            visitor.accept(k, v);
            return true;
        });
    }

    protected <KeyType extends DbKey, ValueType extends DbValue> void whileEqualPrefix(TransactionContext context, KeyType keyInstance, ValueType valueInstance, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(context, (DbKey)new DbNullKey(), keyInstance, valueInstance, visitor);
    }

    protected <KeyType extends DbKey, ValueType extends DbValue> void whileEqualPrefix(TransactionContext context, DbKey prefix, KeyType keyInstance, ValueType valueInstance, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.columnFamilyContext.withPrefixKey(prefix, (prefixKey, prefixLength) -> this.ensureInOpenTransaction(context, transaction -> {
            try (RocksIterator iterator = this.newIterator(context, this.transactionDb.getPrefixReadOptions());){
                boolean shouldVisitNext = true;
                RocksDbInternal.seek(iterator, ZeebeTransactionDb.getNativeHandle((RocksObject)iterator), prefixKey, prefixLength);
                while (iterator.isValid() && shouldVisitNext) {
                    byte[] keyBytes = iterator.key();
                    if (!BufferUtil.startsWith((byte[])prefixKey, (int)0, (int)prefixLength, (byte[])keyBytes, (int)0, (int)keyBytes.length)) {
                        break;
                    }
                    shouldVisitNext = this.visit(keyInstance, valueInstance, visitor, iterator);
                    iterator.next();
                }
            }
        }));
    }

    private <KeyType extends DbKey, ValueType extends DbValue> boolean visit(KeyType keyInstance, ValueType valueInstance, KeyValuePairVisitor<KeyType, ValueType> iteratorConsumer, RocksIterator iterator) {
        byte[] keyBytes = iterator.key();
        this.columnFamilyContext.wrapKeyView(keyBytes);
        this.columnFamilyContext.wrapValueView(iterator.value());
        DirectBuffer keyViewBuffer = this.columnFamilyContext.getKeyView();
        keyInstance.wrap(keyViewBuffer, 0, keyViewBuffer.capacity());
        DirectBuffer valueViewBuffer = this.columnFamilyContext.getValueView();
        valueInstance.wrap(valueViewBuffer, 0, valueViewBuffer.capacity());
        return iteratorConsumer.visit(keyInstance, valueInstance);
    }
}

