/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.db.impl.rocksdb.transaction;

import io.zeebe.db.TransactionOperation;
import io.zeebe.db.ZeebeDbException;
import io.zeebe.db.ZeebeDbTransaction;
import io.zeebe.db.impl.rocksdb.transaction.RocksDbInternal;
import io.zeebe.db.impl.rocksdb.transaction.TransactionRenovator;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Transaction;

public class ZeebeTransaction
implements ZeebeDbTransaction,
AutoCloseable {
    private final long nativeHandle;
    private final TransactionRenovator transactionRenovator;
    private boolean inCurrentTransaction;
    private Transaction transaction;

    public ZeebeTransaction(Transaction transaction, TransactionRenovator transactionRenovator) {
        this.transactionRenovator = transactionRenovator;
        this.transaction = transaction;
        try {
            this.nativeHandle = RocksDbInternal.nativeHandle.getLong(transaction);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void put(long columnFamilyHandle, byte[] key, int keyLength, byte[] value, int valueLength) throws Exception {
        RocksDbInternal.putWithHandle.invoke((Object)this.transaction, this.nativeHandle, key, keyLength, value, valueLength, columnFamilyHandle, false);
    }

    public byte[] get(long columnFamilyHandle, long readOptionsHandle, byte[] key, int keyLength) throws Exception {
        return (byte[])RocksDbInternal.getWithHandle.invoke((Object)this.transaction, this.nativeHandle, readOptionsHandle, key, keyLength, columnFamilyHandle);
    }

    public void delete(long columnFamilyHandle, byte[] key, int keyLength) throws Exception {
        RocksDbInternal.removeWithHandle.invoke((Object)this.transaction, this.nativeHandle, key, keyLength, columnFamilyHandle, false);
    }

    public RocksIterator newIterator(ReadOptions options, ColumnFamilyHandle handle) {
        return this.transaction.getIterator(options, handle);
    }

    void resetTransaction() {
        this.transaction = this.transactionRenovator.renewTransaction(this.transaction);
        this.inCurrentTransaction = true;
    }

    boolean isInCurrentTransaction() {
        return this.inCurrentTransaction;
    }

    @Override
    public void run(TransactionOperation operations) throws Exception {
        try {
            operations.run();
        }
        catch (RocksDBException rdbex) {
            String errorMessage = "Unexpected error occurred during RocksDB transaction commit.";
            if (RocksDbInternal.isRocksDbExceptionRecoverable(rdbex)) {
                throw new ZeebeDbException("Unexpected error occurred during RocksDB transaction commit.", rdbex);
            }
            throw rdbex;
        }
    }

    @Override
    public void commit() throws RocksDBException {
        try {
            this.commitInternal();
        }
        catch (RocksDBException rdbex) {
            String errorMessage = "Unexpected error occurred during RocksDB transaction commit.";
            if (RocksDbInternal.isRocksDbExceptionRecoverable(rdbex)) {
                throw new ZeebeDbException("Unexpected error occurred during RocksDB transaction commit.", rdbex);
            }
            throw rdbex;
        }
    }

    @Override
    public void rollback() throws RocksDBException {
        try {
            this.rollbackInternal();
        }
        catch (RocksDBException rdbex) {
            String errorMessage = "Unexpected error occurred during RocksDB transaction rollback.";
            if (RocksDbInternal.isRocksDbExceptionRecoverable(rdbex)) {
                throw new ZeebeDbException("Unexpected error occurred during RocksDB transaction rollback.", rdbex);
            }
            throw rdbex;
        }
    }

    void commitInternal() throws RocksDBException {
        this.inCurrentTransaction = false;
        this.transaction.commit();
    }

    void rollbackInternal() throws RocksDBException {
        this.inCurrentTransaction = false;
        this.transaction.rollback();
    }

    @Override
    public void close() {
        this.transaction.close();
    }
}

