/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.grpc.stub.StreamObserver;
import io.zeebe.client.api.JsonMapper;
import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.api.response.ProcessInstanceResult;
import io.zeebe.client.impl.RetriableClientFutureImpl;
import io.zeebe.client.impl.response.CreateProcessInstanceWithResultResponseImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class CreateProcessInstanceWithResultCommandImpl
implements CreateProcessInstanceCommandStep1.CreateProcessInstanceWithResultCommandStep1 {
    private static final Duration DEADLINE_OFFSET = Duration.ofSeconds(10L);
    private final JsonMapper jsonMapper;
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.CreateProcessInstanceRequest.Builder createProcessInstanceRequestBuilder;
    private final GatewayOuterClass.CreateProcessInstanceWithResultRequest.Builder builder;
    private final Predicate<Throwable> retryPredicate;
    private Duration requestTimeout;

    public CreateProcessInstanceWithResultCommandImpl(JsonMapper jsonMapper, GatewayGrpc.GatewayStub asyncStub, GatewayOuterClass.CreateProcessInstanceRequest.Builder builder, Predicate<Throwable> retryPredicate, Duration requestTimeout) {
        this.jsonMapper = jsonMapper;
        this.asyncStub = asyncStub;
        this.createProcessInstanceRequestBuilder = builder;
        this.retryPredicate = retryPredicate;
        this.requestTimeout = requestTimeout;
        this.builder = GatewayOuterClass.CreateProcessInstanceWithResultRequest.newBuilder();
    }

    @Override
    public FinalCommandStep<ProcessInstanceResult> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.builder.setRequestTimeout(requestTimeout.toMillis());
        return this;
    }

    @Override
    public ZeebeFuture<ProcessInstanceResult> send() {
        GatewayOuterClass.CreateProcessInstanceWithResultRequest request = this.builder.setRequest(this.createProcessInstanceRequestBuilder).setRequestTimeout(this.requestTimeout.toMillis()).build();
        RetriableClientFutureImpl<ProcessInstanceResult, GatewayOuterClass.CreateProcessInstanceWithResultResponse> future = new RetriableClientFutureImpl<ProcessInstanceResult, GatewayOuterClass.CreateProcessInstanceWithResultResponse>(response -> new CreateProcessInstanceWithResultResponseImpl(this.jsonMapper, (GatewayOuterClass.CreateProcessInstanceWithResultResponse)response), this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.CreateProcessInstanceWithResultResponse>)streamObserver));
        this.send(request, future);
        return future;
    }

    private void send(GatewayOuterClass.CreateProcessInstanceWithResultRequest request, StreamObserver<GatewayOuterClass.CreateProcessInstanceWithResultResponse> future) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.plus(DEADLINE_OFFSET).toMillis(), TimeUnit.MILLISECONDS)).createProcessInstanceWithResult(request, future);
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceWithResultCommandStep1 fetchVariables(List<String> fetchVariables) {
        this.builder.addAllFetchVariables(fetchVariables);
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceWithResultCommandStep1 fetchVariables(String ... fetchVariables) {
        this.builder.addAllFetchVariables(Arrays.asList(fetchVariables));
        return this;
    }
}

