/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.grpc.stub.StreamObserver;
import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.FailJobCommandStep1;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.api.response.FailJobResponse;
import io.zeebe.client.impl.RetriableClientFutureImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class FailJobCommandImpl
implements FailJobCommandStep1,
FailJobCommandStep1.FailJobCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.FailJobRequest.Builder builder;
    private final Predicate<Throwable> retryPredicate;
    private Duration requestTimeout;

    public FailJobCommandImpl(GatewayGrpc.GatewayStub asyncStub, long key, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.FailJobRequest.newBuilder();
        this.builder.setJobKey(key);
    }

    @Override
    public FailJobCommandStep1.FailJobCommandStep2 retries(int retries) {
        this.builder.setRetries(retries);
        return this;
    }

    @Override
    public FailJobCommandStep1.FailJobCommandStep2 errorMessage(String errorMsg) {
        this.builder.setErrorMessage(errorMsg);
        return this;
    }

    @Override
    public FinalCommandStep<FailJobResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<FailJobResponse> send() {
        GatewayOuterClass.FailJobRequest request = this.builder.build();
        RetriableClientFutureImpl future = new RetriableClientFutureImpl(this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.FailJobResponse>)streamObserver));
        this.send(request, future);
        return future;
    }

    private void send(GatewayOuterClass.FailJobRequest request, StreamObserver<GatewayOuterClass.FailJobResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).failJob(request, streamObserver);
    }
}

