/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.grpc.stub.StreamObserver;
import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.api.command.ResolveIncidentCommandStep1;
import io.zeebe.client.api.response.ResolveIncidentResponse;
import io.zeebe.client.impl.RetriableClientFutureImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class ResolveIncidentCommandImpl
implements ResolveIncidentCommandStep1 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.ResolveIncidentRequest.Builder builder;
    private final Predicate<Throwable> retryPredicate;
    private Duration requestTimeout;

    public ResolveIncidentCommandImpl(GatewayGrpc.GatewayStub asyncStub, long incidentKey, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        this.asyncStub = asyncStub;
        this.builder = GatewayOuterClass.ResolveIncidentRequest.newBuilder().setIncidentKey(incidentKey);
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
    }

    @Override
    public FinalCommandStep<ResolveIncidentResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<ResolveIncidentResponse> send() {
        GatewayOuterClass.ResolveIncidentRequest request = this.builder.build();
        RetriableClientFutureImpl future = new RetriableClientFutureImpl(this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.ResolveIncidentResponse>)streamObserver));
        this.send(request, future);
        return future;
    }

    private void send(GatewayOuterClass.ResolveIncidentRequest request, StreamObserver<GatewayOuterClass.ResolveIncidentResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).resolveIncident(request, streamObserver);
    }
}

