/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.client.api.JsonMapper;
import io.zeebe.client.api.response.ActivatedJob;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.Map;

public final class ActivatedJobImpl
implements ActivatedJob {
    @JsonIgnore
    private final JsonMapper jsonMapper;
    private final long key;
    private final String type;
    private final Map<String, String> customHeaders;
    private final long processInstanceKey;
    private final String bpmnProcessId;
    private final int processDefinitionVersion;
    private final long processDefinitionKey;
    private final String elementId;
    private final long elementInstanceKey;
    private final String worker;
    private final int retries;
    private final long deadline;
    private final String variables;

    public ActivatedJobImpl(JsonMapper jsonMapper, GatewayOuterClass.ActivatedJob job) {
        this.jsonMapper = jsonMapper;
        this.key = job.getKey();
        this.type = job.getType();
        this.customHeaders = jsonMapper.fromJsonAsStringMap(job.getCustomHeaders());
        this.worker = job.getWorker();
        this.retries = job.getRetries();
        this.deadline = job.getDeadline();
        this.variables = job.getVariables();
        this.processInstanceKey = job.getProcessInstanceKey();
        this.bpmnProcessId = job.getBpmnProcessId();
        this.processDefinitionVersion = job.getProcessDefinitionVersion();
        this.processDefinitionKey = job.getProcessDefinitionKey();
        this.elementId = job.getElementId();
        this.elementInstanceKey = job.getElementInstanceKey();
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    @Override
    public String getWorker() {
        return this.worker;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public long getDeadline() {
        return this.deadline;
    }

    @Override
    public String getVariables() {
        return this.variables;
    }

    @Override
    public Map<String, Object> getVariablesAsMap() {
        return this.jsonMapper.fromJsonAsMap(this.variables);
    }

    @Override
    public <T> T getVariablesAsType(Class<T> variableType) {
        return this.jsonMapper.fromJson(this.variables, variableType);
    }

    @Override
    public String toJson() {
        return this.jsonMapper.toJson(this);
    }

    public String toString() {
        return this.toJson();
    }
}

