/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.response;

import io.zeebe.client.api.response.BrokerInfo;
import io.zeebe.client.api.response.PartitionInfo;
import io.zeebe.client.impl.response.PartitionInfoImpl;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.ArrayList;
import java.util.List;

public final class BrokerInfoImpl
implements BrokerInfo {
    private final int nodeId;
    private final String host;
    private final int port;
    private final String version;
    private final List<PartitionInfo> partitions;

    public BrokerInfoImpl(GatewayOuterClass.BrokerInfo broker) {
        this.nodeId = broker.getNodeId();
        this.host = broker.getHost();
        this.port = broker.getPort();
        this.version = broker.getVersion();
        this.partitions = new ArrayList<PartitionInfo>();
        for (GatewayOuterClass.Partition partition : broker.getPartitionsList()) {
            this.partitions.add(new PartitionInfoImpl(partition));
        }
    }

    @Override
    public int getNodeId() {
        return this.nodeId;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getAddress() {
        return String.format("%s:%d", this.host, this.port);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public List<PartitionInfo> getPartitions() {
        return this.partitions;
    }

    public String toString() {
        return "BrokerInfoImpl{nodeId=" + this.nodeId + ", host='" + this.host + '\'' + ", port=" + this.port + ", version=" + this.version + ", partitions=" + this.partitions + '}';
    }
}

