/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.worker;

import io.zeebe.client.ZeebeClientConfiguration;
import io.zeebe.client.api.JsonMapper;
import io.zeebe.client.api.command.CompleteJobCommandStep1;
import io.zeebe.client.api.command.FailJobCommandStep1;
import io.zeebe.client.api.command.ThrowErrorCommandStep1;
import io.zeebe.client.api.worker.JobClient;
import io.zeebe.client.impl.command.CompleteJobCommandImpl;
import io.zeebe.client.impl.command.FailJobCommandImpl;
import io.zeebe.client.impl.command.ThrowErrorCommandImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import java.util.function.Predicate;

public final class JobClientImpl
implements JobClient {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final ZeebeClientConfiguration config;
    private final JsonMapper jsonMapper;
    private final Predicate<Throwable> retryPredicate;

    public JobClientImpl(GatewayGrpc.GatewayStub asyncStub, ZeebeClientConfiguration config, JsonMapper jsonMapper, Predicate<Throwable> retryPredicate) {
        this.asyncStub = asyncStub;
        this.config = config;
        this.jsonMapper = jsonMapper;
        this.retryPredicate = retryPredicate;
    }

    @Override
    public CompleteJobCommandStep1 newCompleteCommand(long jobKey) {
        return new CompleteJobCommandImpl(this.asyncStub, this.jsonMapper, jobKey, this.config.getDefaultRequestTimeout(), this.retryPredicate);
    }

    @Override
    public FailJobCommandStep1 newFailCommand(long jobKey) {
        return new FailJobCommandImpl(this.asyncStub, jobKey, this.config.getDefaultRequestTimeout(), this.retryPredicate);
    }

    @Override
    public ThrowErrorCommandStep1 newThrowErrorCommand(long jobKey) {
        return new ThrowErrorCommandImpl(this.asyncStub, jobKey, this.config.getDefaultRequestTimeout(), this.retryPredicate);
    }
}

