/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.worker;

import io.zeebe.client.api.response.ActivatedJob;
import io.zeebe.client.api.worker.JobClient;
import io.zeebe.client.api.worker.JobHandler;
import io.zeebe.client.impl.Loggers;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;

public final class JobRunnableFactory {
    private static final Logger LOG = Loggers.JOB_WORKER_LOGGER;
    private final JobClient jobClient;
    private final JobHandler handler;

    public JobRunnableFactory(JobClient jobClient, JobHandler handler) {
        this.jobClient = jobClient;
        this.handler = handler;
    }

    public Runnable create(ActivatedJob job, Runnable doneCallback) {
        return () -> this.executeJob(job, doneCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJob(ActivatedJob job, Runnable doneCallback) {
        try {
            this.handler.handle(this.jobClient, job);
        }
        catch (Exception e) {
            LOG.warn("Worker {} failed to handle job with key {} of type {}, sending fail command to broker", new Object[]{job.getWorker(), job.getKey(), job.getType(), e});
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String message = stringWriter.toString();
            this.jobClient.newFailCommand(job.getKey()).retries(job.getRetries() - 1).errorMessage(message).send();
        }
        finally {
            doneCallback.run();
        }
    }
}

