/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record;

import io.zeebe.protocol.impl.record.VersionInfo;
import io.zeebe.protocol.record.MessageHeaderDecoder;
import io.zeebe.protocol.record.MessageHeaderEncoder;
import io.zeebe.protocol.record.RecordMetadataDecoder;
import io.zeebe.protocol.record.RecordMetadataEncoder;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.util.VersionUtil;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferUtil;
import io.zeebe.util.buffer.BufferWriter;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class RecordMetadata
implements BufferWriter,
BufferReader {
    public static final int BLOCK_LENGTH = 38;
    private static final VersionInfo CURRENT_BROKER_VERSION = VersionInfo.parse(VersionUtil.getVersion());
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final RecordMetadataEncoder encoder = new RecordMetadataEncoder();
    private final RecordMetadataDecoder decoder = new RecordMetadataDecoder();
    private long requestId;
    private ValueType valueType = ValueType.NULL_VAL;
    private RecordType recordType = RecordType.NULL_VAL;
    private short intentValue = (short)255;
    private Intent intent = null;
    private int requestStreamId;
    private RejectionType rejectionType;
    private final UnsafeBuffer rejectionReason = new UnsafeBuffer(0L, 0);
    private int protocolVersion = 3;
    private VersionInfo brokerVersion = CURRENT_BROKER_VERSION;

    public RecordMetadata() {
        this.reset();
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.reset();
        this.headerDecoder.wrap(buffer, offset);
        this.decoder.wrap(buffer, offset += this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        this.recordType = this.decoder.recordType();
        this.requestStreamId = this.decoder.requestStreamId();
        this.requestId = this.decoder.requestId();
        this.protocolVersion = this.decoder.protocolVersion();
        this.valueType = this.decoder.valueType();
        this.intent = Intent.fromProtocolValue((ValueType)this.valueType, (short)this.decoder.intent());
        this.rejectionType = this.decoder.rejectionType();
        this.brokerVersion = Optional.ofNullable(this.decoder.brokerVersion()).map(versionDecoder -> new VersionInfo(versionDecoder.majorVersion(), versionDecoder.minorVersion(), versionDecoder.patchVersion())).orElse(VersionInfo.UNKNOWN);
        int rejectionReasonLength = this.decoder.rejectionReasonLength();
        if (rejectionReasonLength > 0) {
            offset += this.headerDecoder.blockLength();
            this.rejectionReason.wrap(buffer, offset += RecordMetadataDecoder.rejectionReasonHeaderLength(), rejectionReasonLength);
        }
    }

    public int getLength() {
        return 38 + RecordMetadataEncoder.rejectionReasonHeaderLength() + this.rejectionReason.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset);
        this.headerEncoder.blockLength(this.encoder.sbeBlockLength()).templateId(this.encoder.sbeTemplateId()).schemaId(this.encoder.sbeSchemaId()).version(this.encoder.sbeSchemaVersion());
        this.encoder.wrap(buffer, offset += this.headerEncoder.encodedLength());
        this.encoder.recordType(this.recordType).requestStreamId(this.requestStreamId).requestId(this.requestId).protocolVersion(this.protocolVersion).valueType(this.valueType).intent(this.intentValue).rejectionType(this.rejectionType);
        this.encoder.brokerVersion().majorVersion(this.brokerVersion.getMajorVersion()).minorVersion(this.brokerVersion.getMinorVersion()).patchVersion(this.brokerVersion.getPatchVersion());
        offset += 30;
        if (this.rejectionReason.capacity() > 0) {
            this.encoder.putRejectionReason((DirectBuffer)this.rejectionReason, 0, this.rejectionReason.capacity());
        } else {
            buffer.putInt(offset, 0);
        }
    }

    public long getRequestId() {
        return this.requestId;
    }

    public RecordMetadata requestId(long requestId) {
        this.requestId = requestId;
        return this;
    }

    public int getRequestStreamId() {
        return this.requestStreamId;
    }

    public RecordMetadata requestStreamId(int requestStreamId) {
        this.requestStreamId = requestStreamId;
        return this;
    }

    public RecordMetadata protocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
        return this;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public RecordMetadata valueType(ValueType eventType) {
        this.valueType = eventType;
        return this;
    }

    public RecordMetadata intent(Intent intent) {
        this.intent = intent;
        this.intentValue = intent.value();
        return this;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public RecordMetadata recordType(RecordType recordType) {
        this.recordType = recordType;
        return this;
    }

    public RecordType getRecordType() {
        return this.recordType;
    }

    public RecordMetadata rejectionType(RejectionType rejectionType) {
        this.rejectionType = rejectionType;
        return this;
    }

    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    public RecordMetadata rejectionReason(String rejectionReason) {
        byte[] bytes = rejectionReason.getBytes(StandardCharsets.UTF_8);
        this.rejectionReason.wrap(bytes);
        return this;
    }

    public RecordMetadata rejectionReason(DirectBuffer buffer) {
        this.rejectionReason.wrap(buffer);
        return this;
    }

    public String getRejectionReason() {
        return BufferUtil.bufferAsString((DirectBuffer)this.rejectionReason);
    }

    public RecordMetadata brokerVersion(VersionInfo brokerVersion) {
        this.brokerVersion = brokerVersion;
        return this;
    }

    public VersionInfo getBrokerVersion() {
        return this.brokerVersion;
    }

    public RecordMetadata reset() {
        this.recordType = RecordType.NULL_VAL;
        this.requestId = RecordMetadataEncoder.requestIdNullValue();
        this.requestStreamId = RecordMetadataEncoder.requestStreamIdNullValue();
        this.protocolVersion = 3;
        this.valueType = ValueType.NULL_VAL;
        this.intentValue = (short)255;
        this.intent = null;
        this.rejectionType = RejectionType.NULL_VAL;
        this.rejectionReason.wrap(0L, 0);
        this.brokerVersion = CURRENT_BROKER_VERSION;
        return this;
    }

    public String toString() {
        return "RecordMetadata{recordType=" + this.recordType + ", intentValue=" + this.intentValue + ", intent=" + this.intent + ", requestStreamId=" + this.requestStreamId + ", requestId=" + this.requestId + ", protocolVersion=" + this.protocolVersion + ", valueType=" + this.valueType + ", rejectionType=" + this.rejectionType + ", rejectionReason=" + BufferUtil.bufferAsString((DirectBuffer)this.rejectionReason) + ", brokerVersion=" + this.brokerVersion + "}";
    }
}

