/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VersionInfo {
    public static final VersionInfo UNKNOWN = new VersionInfo(0, 0, 0);
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+).*");
    private final int majorVersion;
    private final int minorVersion;
    private final int patchVersion;

    public VersionInfo(int majorVersion, int minorVersion, int patchVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
    }

    public static VersionInfo parse(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int patch = Integer.parseInt(matcher.group(3));
            return new VersionInfo(major, minor, patch);
        }
        return UNKNOWN;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.minorVersion, this.patchVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionInfo that = (VersionInfo)o;
        return this.majorVersion == that.majorVersion && this.minorVersion == that.minorVersion && this.patchVersion == that.patchVersion;
    }

    public String toString() {
        return this.majorVersion + "." + this.minorVersion + "." + this.patchVersion;
    }
}

