/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.deployment;

import io.zeebe.msgpack.property.ArrayProperty;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.value.BaseValue;
import io.zeebe.msgpack.value.ValueArray;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.zeebe.protocol.record.value.DeploymentRecordValue;
import io.zeebe.protocol.record.value.deployment.DeployedProcess;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class DeploymentRecord
extends UnifiedRecordValue
implements DeploymentRecordValue {
    public static final String RESOURCES = "resources";
    public static final String PROCESSES = "deployedProcesses";
    private final ArrayProperty<DeploymentResource> resourcesProp = new ArrayProperty("resources", (BaseValue)new DeploymentResource());
    private final ArrayProperty<ProcessRecord> processesProp = new ArrayProperty("deployedProcesses", (BaseValue)new ProcessRecord());

    public DeploymentRecord() {
        this.declareProperty((BaseProperty)this.resourcesProp).declareProperty(this.processesProp);
    }

    public ValueArray<ProcessRecord> processes() {
        return this.processesProp;
    }

    public ValueArray<DeploymentResource> resources() {
        return this.resourcesProp;
    }

    public List<io.zeebe.protocol.record.value.deployment.DeploymentResource> getResources() {
        ArrayList<io.zeebe.protocol.record.value.deployment.DeploymentResource> resources = new ArrayList<io.zeebe.protocol.record.value.deployment.DeploymentResource>();
        for (DeploymentResource resource : this.resourcesProp) {
            byte[] bytes = new byte[resource.getLength()];
            UnsafeBuffer copyBuffer = new UnsafeBuffer(bytes);
            resource.write((MutableDirectBuffer)copyBuffer, 0);
            DeploymentResource copiedResource = new DeploymentResource();
            copiedResource.wrap((DirectBuffer)copyBuffer);
            resources.add(copiedResource);
        }
        return resources;
    }

    public List<DeployedProcess> getDeployedProcesses() {
        ArrayList<DeployedProcess> processes = new ArrayList<DeployedProcess>();
        for (ProcessRecord processRecord : this.processesProp) {
            byte[] bytes = new byte[processRecord.getLength()];
            UnsafeBuffer copyBuffer = new UnsafeBuffer(bytes);
            processRecord.write((MutableDirectBuffer)copyBuffer, 0);
            ProcessRecord copiedProcessRecord = new ProcessRecord();
            copiedProcessRecord.wrap((DirectBuffer)copyBuffer);
            processes.add(copiedProcessRecord);
        }
        return processes;
    }
}

