/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.deployment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.BinaryProperty;
import io.zeebe.msgpack.property.EnumProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.protocol.record.value.deployment.ResourceType;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class DeploymentResource
extends UnpackedObject
implements io.zeebe.protocol.record.value.deployment.DeploymentResource {
    private final BinaryProperty resourceProp = new BinaryProperty("resource");
    private final EnumProperty<ResourceType> resourceTypeProp = new EnumProperty("resourceType", ResourceType.class, (Enum)ResourceType.BPMN_XML);
    private final StringProperty resourceNameProp = new StringProperty("resourceName", "resource");

    public DeploymentResource() {
        this.declareProperty((BaseProperty)this.resourceTypeProp).declareProperty((BaseProperty)this.resourceNameProp).declareProperty((BaseProperty)this.resourceProp);
    }

    public byte[] getResource() {
        return BufferUtil.bufferAsArray((DirectBuffer)this.resourceProp.getValue());
    }

    public ResourceType getResourceType() {
        return (ResourceType)this.resourceTypeProp.getValue();
    }

    public String getResourceName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.resourceNameProp.getValue());
    }

    public DeploymentResource setResourceName(String resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public DeploymentResource setResourceName(DirectBuffer resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public DeploymentResource setResourceType(ResourceType resourceType) {
        this.resourceTypeProp.setValue((Enum)resourceType);
        return this;
    }

    public DeploymentResource setResource(byte[] resource) {
        return this.setResource((DirectBuffer)BufferUtil.wrapArray((byte[])resource));
    }

    public DeploymentResource setResource(DirectBuffer resource) {
        return this.setResource(resource, 0, resource.capacity());
    }

    @JsonIgnore
    public DirectBuffer getResourceBuffer() {
        return this.resourceProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getResourceNameBuffer() {
        return this.resourceNameProp.getValue();
    }

    @JsonIgnore
    public int getLength() {
        return super.getLength();
    }

    @JsonIgnore
    public int getEncodedLength() {
        return super.getEncodedLength();
    }

    public DeploymentResource setResource(DirectBuffer resource, int offset, int length) {
        this.resourceProp.setValue(resource, offset, length);
        return this;
    }
}

