/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.deployment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.BinaryProperty;
import io.zeebe.msgpack.property.IntegerProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.value.deployment.DeployedProcess;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ProcessRecord
extends UnifiedRecordValue
implements DeployedProcess {
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId");
    private final IntegerProperty versionProp = new IntegerProperty("version");
    private final LongProperty keyProp = new LongProperty("processDefinitionKey");
    private final StringProperty resourceNameProp = new StringProperty("resourceName");
    private final BinaryProperty checksumProp = new BinaryProperty("checksum");
    private final BinaryProperty resourceProp = new BinaryProperty("resource");

    public ProcessRecord() {
        this.declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.versionProp).declareProperty((BaseProperty)this.keyProp).declareProperty((BaseProperty)this.resourceNameProp).declareProperty((BaseProperty)this.checksumProp).declareProperty((BaseProperty)this.resourceProp);
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public int getVersion() {
        return this.versionProp.getValue();
    }

    public long getProcessDefinitionKey() {
        return this.getKey();
    }

    public String getResourceName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.resourceNameProp.getValue());
    }

    @JsonIgnore
    public DirectBuffer getChecksumBuffer() {
        return this.checksumProp.getValue();
    }

    public byte[] getChecksum() {
        return BufferUtil.bufferAsArray((DirectBuffer)this.checksumProp.getValue());
    }

    public byte[] getResource() {
        return BufferUtil.bufferAsArray((DirectBuffer)this.resourceProp.getValue());
    }

    public ProcessRecord setResourceName(String resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public ProcessRecord setResourceName(DirectBuffer resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public ProcessRecord setVersion(int version) {
        this.versionProp.setValue(version);
        return this;
    }

    public ProcessRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public ProcessRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    @JsonIgnore
    public long getKey() {
        return this.keyProp.getValue();
    }

    public ProcessRecord setKey(long key) {
        this.keyProp.setValue(key);
        return this;
    }

    public ProcessRecord setChecksum(DirectBuffer checksumBuffer) {
        this.checksumProp.setValue(checksumBuffer);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @Override
    @JsonIgnore
    public int getEncodedLength() {
        return super.getEncodedLength();
    }

    @Override
    @JsonIgnore
    public int getLength() {
        return super.getLength();
    }

    @JsonIgnore
    public DirectBuffer getResourceNameBuffer() {
        return this.resourceNameProp.getValue();
    }

    public ProcessRecord setBpmnProcessId(DirectBuffer bpmnProcessId, int offset, int length) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId, offset, length);
        return this;
    }

    public ProcessRecord setResource(DirectBuffer resource) {
        return this.setResource(resource, 0, resource.capacity());
    }

    public ProcessRecord setResource(DirectBuffer resource, int offset, int length) {
        this.resourceProp.setValue(resource, offset, length);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getResourceBuffer() {
        return this.resourceProp.getValue();
    }
}

