/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.BooleanProperty;
import io.zeebe.msgpack.property.DocumentProperty;
import io.zeebe.msgpack.property.IntegerProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.value.ProcessInstanceSubscriptionRecordValue;
import io.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class ProcessInstanceSubscriptionRecord
extends UnifiedRecordValue
implements ProcessInstanceSubscriptionRecordValue {
    private final IntegerProperty subscriptionPartitionIdProp = new IntegerProperty("subscriptionPartitionId");
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey");
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey");
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final LongProperty messageKeyProp = new LongProperty("messageKey", -1L);
    private final StringProperty messageNameProp = new StringProperty("messageName", "");
    private final DocumentProperty variablesProp = new DocumentProperty("variables");
    private final BooleanProperty interruptingProp = new BooleanProperty("interrupting", true);
    private final StringProperty correlationKeyProp = new StringProperty("correlationKey", "");
    private final StringProperty elementIdProp = new StringProperty("elementId", "");

    public ProcessInstanceSubscriptionRecord() {
        this.declareProperty((BaseProperty)this.subscriptionPartitionIdProp).declareProperty((BaseProperty)this.processInstanceKeyProp).declareProperty((BaseProperty)this.elementInstanceKeyProp).declareProperty((BaseProperty)this.messageKeyProp).declareProperty((BaseProperty)this.messageNameProp).declareProperty((BaseProperty)this.variablesProp).declareProperty((BaseProperty)this.interruptingProp).declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.correlationKeyProp).declareProperty((BaseProperty)this.elementIdProp);
    }

    public boolean isInterrupting() {
        return this.interruptingProp.getValue();
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    public ProcessInstanceSubscriptionRecord setElementInstanceKey(long key) {
        this.elementInstanceKeyProp.setValue(key);
        return this;
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public ProcessInstanceSubscriptionRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public long getMessageKey() {
        return this.messageKeyProp.getValue();
    }

    public String getMessageName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.messageNameProp.getValue());
    }

    public String getCorrelationKey() {
        return BufferUtil.bufferAsString((DirectBuffer)this.correlationKeyProp.getValue());
    }

    public ProcessInstanceSubscriptionRecord setCorrelationKey(DirectBuffer correlationKey) {
        this.correlationKeyProp.setValue(correlationKey);
        return this;
    }

    public ProcessInstanceSubscriptionRecord setMessageName(DirectBuffer messageName) {
        this.messageNameProp.setValue(messageName);
        return this;
    }

    public ProcessInstanceSubscriptionRecord setMessageKey(long messageKey) {
        this.messageKeyProp.setValue(messageKey);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getMessageNameBuffer() {
        return this.messageNameProp.getValue();
    }

    @JsonIgnore
    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionIdProp.getValue();
    }

    public ProcessInstanceSubscriptionRecord setSubscriptionPartitionId(int partitionId) {
        this.subscriptionPartitionIdProp.setValue(partitionId);
        return this;
    }

    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProp.getValue());
    }

    public ProcessInstanceSubscriptionRecord setVariables(DirectBuffer variables) {
        this.variablesProp.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProp.getValue();
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public ProcessInstanceSubscriptionRecord setProcessInstanceKey(long key) {
        this.processInstanceKeyProp.setValue(key);
        return this;
    }

    public ProcessInstanceSubscriptionRecord setInterrupting(boolean interrupting) {
        this.interruptingProp.setValue(interrupting);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getCorrelationKeyBuffer() {
        return this.correlationKeyProp.getValue();
    }

    public String getElementId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.getElementIdBuffer());
    }

    public ProcessInstanceSubscriptionRecord setElementId(DirectBuffer elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProp.getValue();
    }
}

