/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.el.impl.feel;

import io.zeebe.el.impl.Loggers;
import io.zeebe.el.impl.feel.MessagePackContext;
import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackToken;
import io.zeebe.msgpack.spec.MsgPackType;
import io.zeebe.util.buffer.BufferUtil;
import java.io.Serializable;
import org.agrona.DirectBuffer;
import org.camunda.feel.context.Context;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.syntaxtree.ValBoolean;
import org.camunda.feel.syntaxtree.ValContext;
import org.camunda.feel.syntaxtree.ValList;
import org.camunda.feel.syntaxtree.ValNull$;
import org.camunda.feel.syntaxtree.ValNumber;
import org.camunda.feel.syntaxtree.ValString;
import org.camunda.feel.valuemapper.CustomValueMapper;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.math.BigDecimal$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005)4A!\u0003\u0006\u0001+!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0013a\u0003BB\u001b\u0001A\u0003%Q\u0006C\u00037\u0001\u0011\u0005s\u0007C\u0003L\u0001\u0011%A\nC\u0003V\u0001\u0011%a\u000bC\u0003X\u0001\u0011%\u0001\fC\u0003d\u0001\u0011\u0005CM\u0001\fNKN\u001c\u0018mZ3QC\u000e\\g+\u00197vK6\u000b\u0007\u000f]3s\u0015\tYA\"\u0001\u0003gK\u0016d'BA\u0007\u000f\u0003\u0011IW\u000e\u001d7\u000b\u0005=\u0001\u0012AA3m\u0015\t\t\"#A\u0003{K\u0016\u0014WMC\u0001\u0014\u0003\tIwn\u0001\u0001\u0014\u0007\u00011B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;\u0015j\u0011A\b\u0006\u0003?\u0001\n1B^1mk\u0016l\u0017\r\u001d9fe*\u00111\"\t\u0006\u0003E\r\nqaY1nk:$\u0017MC\u0001%\u0003\ry'oZ\u0005\u0003My\u0011\u0011cQ;ti>lg+\u00197vK6\u000b\u0007\u000f]3s\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\t!\"\u0001\u0004sK\u0006$WM]\u000b\u0002[A\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0005gB,7M\u0003\u00023!\u00059Qn]4qC\u000e\\\u0017B\u0001\u001b0\u00055i5o\u001a)bG.\u0014V-\u00193fe\u00069!/Z1eKJ\u0004\u0013!\u0002;p-\u0006dGc\u0001\u001dB\rB\u0019q#O\u001e\n\u0005iB\"AB(qi&|g\u000e\u0005\u0002=\u007f5\tQH\u0003\u0002?A\u0005Q1/\u001f8uCb$(/Z3\n\u0005\u0001k$a\u0001,bY\")!\t\u0002a\u0001\u0007\u0006\t\u0001\u0010\u0005\u0002\u0018\t&\u0011Q\t\u0007\u0002\u0004\u0003:L\b\"B$\u0005\u0001\u0004A\u0015\u0001E5o]\u0016\u0014h+\u00197vK6\u000b\u0007\u000f]3s!\u00119\u0012jQ\u001e\n\u0005)C\"!\u0003$v]\u000e$\u0018n\u001c82\u0003=\u0011X-\u00193NKN\u001c\u0018mZ3QC\u000e\\GCA\u001eN\u0011\u0015qU\u00011\u0001P\u0003-iWm]:bO\u0016\u0004\u0016mY6\u0011\u0005A\u001bV\"A)\u000b\u0005I\u001b\u0013AB1he>t\u0017-\u0003\u0002U#\naA)\u001b:fGR\u0014UO\u001a4fe\u0006A!/Z1e\u001d\u0016DH\u000fF\u0001<\u0003\u0011\u0011X-\u00193\u0015\u0007mJf\fC\u0003[\u000f\u0001\u00071,A\u0003u_.,g\u000e\u0005\u0002/9&\u0011Ql\f\u0002\r\u001bN<\u0007+Y2l)>\\WM\u001c\u0005\u0006?\u001e\u0001\r\u0001Y\u0001\u0007_\u001a47/\u001a;\u0011\u0005]\t\u0017B\u00012\u0019\u0005\rIe\u000e^\u0001\nk:\u0004\u0018mY6WC2$2!\u001a4i!\r9\u0012h\u0011\u0005\u0006O\"\u0001\raO\u0001\u0006m\u0006dW/\u001a\u0005\u0006\u000f\"\u0001\r!\u001b\t\u0005/%[4\t")
public class MessagePackValueMapper
implements CustomValueMapper {
    private final MsgPackReader reader;
    private int priority;

    public int priority() {
        return this.priority;
    }

    public void org$camunda$feel$valuemapper$CustomValueMapper$_setter_$priority_$eq(int x$1) {
        this.priority = x$1;
    }

    private MsgPackReader reader() {
        return this.reader;
    }

    public Option<Val> toVal(Object x, Function1<Object, Val> innerValueMapper) {
        None$ none$;
        Object object = x;
        if (object instanceof DirectBuffer) {
            DirectBuffer directBuffer = (DirectBuffer)object;
            Val value = this.readMessagePack(directBuffer);
            none$ = new Some((Object)value);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Val readMessagePack(DirectBuffer messagePack) {
        this.reader().wrap(messagePack, 0, messagePack.capacity());
        return this.readNext();
    }

    private Val readNext() {
        int offset = this.reader().getOffset();
        MsgPackToken token = this.reader().readToken();
        return this.read(token, offset);
    }

    private Val read(MsgPackToken token, int offset) {
        ValNull$ valNull$;
        MsgPackType msgPackType = token.getType();
        if (MsgPackType.NIL.equals(msgPackType)) {
            valNull$ = ValNull$.MODULE$;
        } else if (MsgPackType.BOOLEAN.equals(msgPackType)) {
            valNull$ = new ValBoolean(token.getBooleanValue());
        } else if (MsgPackType.INTEGER.equals(msgPackType)) {
            valNull$ = new ValNumber(BigDecimal$.MODULE$.long2bigDecimal(token.getIntegerValue()));
        } else if (MsgPackType.FLOAT.equals(msgPackType)) {
            valNull$ = new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(token.getFloatValue()));
        } else if (MsgPackType.STRING.equals(msgPackType)) {
            String asString = BufferUtil.bufferAsString((DirectBuffer)token.getValueBuffer());
            valNull$ = new ValString(asString);
        } else if (MsgPackType.ARRAY.equals(msgPackType)) {
            List items = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), token.getSize()).map((Function1 & Serializable)x$1 -> this.readNext()).toList();
            valNull$ = new ValList(items);
        } else if (MsgPackType.MAP.equals(msgPackType)) {
            MessagePackContext context = new MessagePackContext(this.reader(), offset, token.getSize());
            valNull$ = new ValContext((Context)context);
        } else {
            Loggers.LOGGER.warn("No MessagePack to FEEL transformation for type '{}'. Using 'null' instead.", (Object)msgPackType);
            valNull$ = ValNull$.MODULE$;
        }
        return valNull$;
    }

    public Option<Object> unpackVal(Val value, Function1<Val, Object> innerValueMapper) {
        return new Some((Object)value);
    }

    public MessagePackValueMapper() {
        CustomValueMapper.$init$((CustomValueMapper)this);
        this.reader = new MsgPackReader();
        Statics.releaseFence();
    }
}

