/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway;

import io.atomix.cluster.AtomixCluster;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.netty.NettyServerBuilder;
import io.zeebe.gateway.EndpointManager;
import io.zeebe.gateway.GatewayGrpcService;
import io.zeebe.gateway.Loggers;
import io.zeebe.gateway.impl.broker.BrokerClient;
import io.zeebe.gateway.impl.broker.BrokerClientImpl;
import io.zeebe.gateway.impl.configuration.GatewayCfg;
import io.zeebe.gateway.impl.configuration.NetworkCfg;
import io.zeebe.gateway.impl.configuration.SecurityCfg;
import io.zeebe.gateway.impl.job.ActivateJobsHandler;
import io.zeebe.gateway.impl.job.LongPollingActivateJobsHandler;
import io.zeebe.gateway.impl.job.RoundRobinActivateJobsHandler;
import io.zeebe.util.VersionUtil;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.MonitoringServerInterceptor;
import org.slf4j.Logger;

public final class Gateway {
    private static final Logger LOG = Loggers.GATEWAY_LOGGER;
    private static final Function<GatewayCfg, ServerBuilder> DEFAULT_SERVER_BUILDER_FACTORY = cfg -> Gateway.setNetworkConfig(cfg.getNetwork());
    private final Function<GatewayCfg, ServerBuilder> serverBuilderFactory;
    private final Function<GatewayCfg, BrokerClient> brokerClientFactory;
    private final GatewayCfg gatewayCfg;
    private final ActorScheduler actorScheduler;
    private Server server;
    private BrokerClient brokerClient;
    private volatile Status status = Status.INITIAL;

    public Gateway(GatewayCfg gatewayCfg, AtomixCluster atomixCluster, ActorScheduler actorScheduler) {
        this(gatewayCfg, cfg -> new BrokerClientImpl((GatewayCfg)cfg, atomixCluster), DEFAULT_SERVER_BUILDER_FACTORY, actorScheduler);
    }

    public Gateway(GatewayCfg gatewayCfg, Function<GatewayCfg, BrokerClient> brokerClientFactory, ActorScheduler actorScheduler) {
        this(gatewayCfg, brokerClientFactory, DEFAULT_SERVER_BUILDER_FACTORY, actorScheduler);
    }

    public Gateway(GatewayCfg gatewayCfg, Function<GatewayCfg, BrokerClient> brokerClientFactory, Function<GatewayCfg, ServerBuilder> serverBuilderFactory, ActorScheduler actorScheduler) {
        this.gatewayCfg = gatewayCfg;
        this.brokerClientFactory = brokerClientFactory;
        this.serverBuilderFactory = serverBuilderFactory;
        this.actorScheduler = actorScheduler;
    }

    public GatewayCfg getGatewayCfg() {
        return this.gatewayCfg;
    }

    public Status getStatus() {
        return this.status;
    }

    public BrokerClient getBrokerClient() {
        return this.brokerClient;
    }

    public void start() throws IOException {
        ActivateJobsHandler activateJobsHandler;
        this.status = Status.STARTING;
        if (LOG.isInfoEnabled()) {
            LOG.info("Version: {}", (Object)VersionUtil.getVersion());
            LOG.info("Starting gateway with configuration {}", (Object)this.gatewayCfg.toJson());
        }
        this.brokerClient = this.buildBrokerClient();
        if (this.gatewayCfg.getLongPolling().isEnabled()) {
            LongPollingActivateJobsHandler longPollingHandler = this.buildLongPollingHandler(this.brokerClient);
            this.actorScheduler.submitActor((Actor)longPollingHandler);
            activateJobsHandler = longPollingHandler;
        } else {
            activateJobsHandler = new RoundRobinActivateJobsHandler(this.brokerClient);
        }
        EndpointManager endpointManager = new EndpointManager(this.brokerClient, activateJobsHandler);
        GatewayGrpcService gatewayGrpcService = new GatewayGrpcService(endpointManager);
        ServerBuilder serverBuilder = this.serverBuilderFactory.apply(this.gatewayCfg);
        if (this.gatewayCfg.getMonitoring().isEnabled()) {
            MonitoringServerInterceptor monitoringInterceptor = MonitoringServerInterceptor.create((Configuration)Configuration.allMetrics());
            serverBuilder.addService(ServerInterceptors.intercept((BindableService)gatewayGrpcService, (ServerInterceptor[])new ServerInterceptor[]{monitoringInterceptor}));
        } else {
            serverBuilder.addService((BindableService)gatewayGrpcService);
        }
        SecurityCfg securityCfg = this.gatewayCfg.getSecurity();
        if (securityCfg.isEnabled()) {
            this.setSecurityConfig(serverBuilder, securityCfg);
        }
        this.server = serverBuilder.build();
        this.server.start();
        this.status = Status.RUNNING;
    }

    private static NettyServerBuilder setNetworkConfig(NetworkCfg cfg) {
        Duration minKeepAliveInterval = cfg.getMinKeepAliveInterval();
        if (minKeepAliveInterval.isNegative() || minKeepAliveInterval.isZero()) {
            throw new IllegalArgumentException("Minimum keep alive interval must be positive.");
        }
        return NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(cfg.getHost(), cfg.getPort())).permitKeepAliveTime(minKeepAliveInterval.toMillis(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(false);
    }

    private void setSecurityConfig(ServerBuilder<?> serverBuilder, SecurityCfg security) {
        if (security.getCertificateChainPath() == null) {
            throw new IllegalArgumentException("Expected to find a valid path to a certificate chain but none was found. Edit the gateway configuration file to provide one or to disable TLS.");
        }
        if (security.getPrivateKeyPath() == null) {
            throw new IllegalArgumentException("Expected to find a valid path to a private key but none was found. Edit the gateway configuration file to provide one or to disable TLS.");
        }
        File certChain = new File(security.getCertificateChainPath());
        File privateKey = new File(security.getPrivateKeyPath());
        if (!certChain.exists()) {
            throw new IllegalArgumentException(String.format("Expected to find a certificate chain file at the provided location '%s' but none was found.", security.getCertificateChainPath()));
        }
        if (!privateKey.exists()) {
            throw new IllegalArgumentException(String.format("Expected to find a private key file at the provided location '%s' but none was found.", security.getPrivateKeyPath()));
        }
        serverBuilder.useTransportSecurity(certChain, privateKey);
    }

    private BrokerClient buildBrokerClient() {
        return this.brokerClientFactory.apply(this.gatewayCfg);
    }

    private LongPollingActivateJobsHandler buildLongPollingHandler(BrokerClient brokerClient) {
        return LongPollingActivateJobsHandler.newBuilder().setBrokerClient(brokerClient).build();
    }

    public void listenAndServe() throws InterruptedException, IOException {
        this.start();
        this.server.awaitTermination();
    }

    public void stop() {
        this.status = Status.SHUTDOWN;
        if (this.server != null && !this.server.isShutdown()) {
            this.server.shutdownNow();
            try {
                this.server.awaitTermination();
            }
            catch (InterruptedException e) {
                LOG.error("Failed to await termination of gateway", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            finally {
                this.server = null;
            }
        }
        if (this.brokerClient != null) {
            this.brokerClient.close();
            this.brokerClient = null;
        }
    }

    public static enum Status {
        INITIAL,
        STARTING,
        RUNNING,
        SHUTDOWN;

    }
}

