/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway;

import io.zeebe.gateway.impl.broker.request.BrokerActivateJobsRequest;
import io.zeebe.gateway.impl.broker.request.BrokerCancelProcessInstanceRequest;
import io.zeebe.gateway.impl.broker.request.BrokerCompleteJobRequest;
import io.zeebe.gateway.impl.broker.request.BrokerCreateProcessInstanceRequest;
import io.zeebe.gateway.impl.broker.request.BrokerCreateProcessInstanceWithResultRequest;
import io.zeebe.gateway.impl.broker.request.BrokerDeployProcessRequest;
import io.zeebe.gateway.impl.broker.request.BrokerFailJobRequest;
import io.zeebe.gateway.impl.broker.request.BrokerPublishMessageRequest;
import io.zeebe.gateway.impl.broker.request.BrokerResolveIncidentRequest;
import io.zeebe.gateway.impl.broker.request.BrokerSetVariablesRequest;
import io.zeebe.gateway.impl.broker.request.BrokerThrowErrorRequest;
import io.zeebe.gateway.impl.broker.request.BrokerUpdateJobRetriesRequest;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import io.zeebe.msgpack.value.DocumentValue;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class RequestMapper {
    public static BrokerDeployProcessRequest toDeployProcessRequest(GatewayOuterClass.DeployProcessRequest grpcRequest) {
        BrokerDeployProcessRequest brokerRequest = new BrokerDeployProcessRequest();
        for (GatewayOuterClass.ProcessRequestObject process : grpcRequest.getProcessesList()) {
            brokerRequest.addResource(process.getDefinition().toByteArray(), process.getName());
        }
        return brokerRequest;
    }

    public static BrokerPublishMessageRequest toPublishMessageRequest(GatewayOuterClass.PublishMessageRequest grpcRequest) {
        BrokerPublishMessageRequest brokerRequest = new BrokerPublishMessageRequest(grpcRequest.getName(), grpcRequest.getCorrelationKey());
        brokerRequest.setMessageId(grpcRequest.getMessageId()).setTimeToLive(grpcRequest.getTimeToLive()).setVariables(RequestMapper.ensureJsonSet(grpcRequest.getVariables()));
        return brokerRequest;
    }

    public static BrokerUpdateJobRetriesRequest toUpdateJobRetriesRequest(GatewayOuterClass.UpdateJobRetriesRequest grpcRequest) {
        return new BrokerUpdateJobRetriesRequest(grpcRequest.getJobKey(), grpcRequest.getRetries());
    }

    public static BrokerFailJobRequest toFailJobRequest(GatewayOuterClass.FailJobRequest grpcRequest) {
        return new BrokerFailJobRequest(grpcRequest.getJobKey(), grpcRequest.getRetries()).setErrorMessage(grpcRequest.getErrorMessage());
    }

    public static BrokerThrowErrorRequest toThrowErrorRequest(GatewayOuterClass.ThrowErrorRequest grpcRequest) {
        return new BrokerThrowErrorRequest(grpcRequest.getJobKey(), grpcRequest.getErrorCode()).setErrorMessage(grpcRequest.getErrorMessage());
    }

    public static BrokerCompleteJobRequest toCompleteJobRequest(GatewayOuterClass.CompleteJobRequest grpcRequest) {
        return new BrokerCompleteJobRequest(grpcRequest.getJobKey(), RequestMapper.ensureJsonSet(grpcRequest.getVariables()));
    }

    public static BrokerCreateProcessInstanceRequest toCreateProcessInstanceRequest(GatewayOuterClass.CreateProcessInstanceRequest grpcRequest) {
        BrokerCreateProcessInstanceRequest brokerRequest = new BrokerCreateProcessInstanceRequest();
        brokerRequest.setBpmnProcessId(grpcRequest.getBpmnProcessId()).setKey(grpcRequest.getProcessDefinitionKey()).setVersion(grpcRequest.getVersion()).setVariables(RequestMapper.ensureJsonSet(grpcRequest.getVariables()));
        return brokerRequest;
    }

    public static BrokerCreateProcessInstanceWithResultRequest toCreateProcessInstanceWithResultRequest(GatewayOuterClass.CreateProcessInstanceWithResultRequest grpcRequest) {
        BrokerCreateProcessInstanceWithResultRequest brokerRequest = new BrokerCreateProcessInstanceWithResultRequest();
        GatewayOuterClass.CreateProcessInstanceRequest request = grpcRequest.getRequest();
        brokerRequest.setBpmnProcessId(request.getBpmnProcessId()).setKey(request.getProcessDefinitionKey()).setVersion(request.getVersion()).setVariables(RequestMapper.ensureJsonSet(request.getVariables())).setFetchVariables((List<String>)grpcRequest.getFetchVariablesList());
        return brokerRequest;
    }

    public static BrokerCancelProcessInstanceRequest toCancelProcessInstanceRequest(GatewayOuterClass.CancelProcessInstanceRequest grpcRequest) {
        BrokerCancelProcessInstanceRequest brokerRequest = new BrokerCancelProcessInstanceRequest();
        brokerRequest.setProcessInstanceKey(grpcRequest.getProcessInstanceKey());
        return brokerRequest;
    }

    public static BrokerSetVariablesRequest toSetVariablesRequest(GatewayOuterClass.SetVariablesRequest grpcRequest) {
        BrokerSetVariablesRequest brokerRequest = new BrokerSetVariablesRequest();
        brokerRequest.setElementInstanceKey(grpcRequest.getElementInstanceKey());
        brokerRequest.setVariables(RequestMapper.ensureJsonSet(grpcRequest.getVariables()));
        brokerRequest.setLocal(grpcRequest.getLocal());
        return brokerRequest;
    }

    public static BrokerActivateJobsRequest toActivateJobsRequest(GatewayOuterClass.ActivateJobsRequest grpcRequest) {
        return new BrokerActivateJobsRequest(grpcRequest.getType()).setTimeout(grpcRequest.getTimeout()).setWorker(grpcRequest.getWorker()).setMaxJobsToActivate(grpcRequest.getMaxJobsToActivate()).setVariables((List<String>)grpcRequest.getFetchVariableList());
    }

    public static BrokerResolveIncidentRequest toResolveIncidentRequest(GatewayOuterClass.ResolveIncidentRequest grpcRequest) {
        return new BrokerResolveIncidentRequest(grpcRequest.getIncidentKey());
    }

    private static DirectBuffer ensureJsonSet(String value) {
        if (value == null || value.trim().isEmpty()) {
            return DocumentValue.EMPTY_DOCUMENT;
        }
        return new UnsafeBuffer(MsgPackConverter.convertToMsgPack((String)value));
    }
}

