/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.cmd;

import io.zeebe.gateway.cmd.ClientException;

public class PartitionNotFoundException
extends ClientException {
    private static final String DEFAULT_ERROR_MESSAGE = "Expected to execute command on partition %d, but either it does not exist, or the gateway is not yet aware of it";
    private final int partitionId;

    public PartitionNotFoundException(int partitionId) {
        this(String.format(DEFAULT_ERROR_MESSAGE, partitionId), partitionId);
    }

    public PartitionNotFoundException(String message, int partitionId) {
        super(message);
        this.partitionId = partitionId;
    }

    public PartitionNotFoundException(String message, Throwable cause, int partitionId) {
        super(message, cause);
        this.partitionId = partitionId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }
}

