/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.grpc;

import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import io.zeebe.gateway.Loggers;
import io.zeebe.gateway.grpc.GrpcErrorMapper;
import io.zeebe.gateway.grpc.ServerStreamObserver;

public final class ErrorMappingStreamObserver<GrpcResponseT>
extends ServerCallStreamObserver<GrpcResponseT>
implements ServerStreamObserver<GrpcResponseT> {
    private static final GrpcErrorMapper DEFAULT_ERROR_MAPPER = new GrpcErrorMapper();
    private final ServerCallStreamObserver<GrpcResponseT> delegate;
    private final GrpcErrorMapper errorMapper;

    public ErrorMappingStreamObserver(ServerCallStreamObserver<GrpcResponseT> delegate) {
        this(delegate, DEFAULT_ERROR_MAPPER);
    }

    public ErrorMappingStreamObserver(ServerCallStreamObserver<GrpcResponseT> delegate, GrpcErrorMapper errorMapper) {
        this.delegate = delegate;
        this.errorMapper = errorMapper;
        this.suppressCancelException();
    }

    public static <GrpcResponseT> ErrorMappingStreamObserver<GrpcResponseT> ofStreamObserver(StreamObserver<GrpcResponseT> streamObserver) {
        if (!(streamObserver instanceof ServerCallStreamObserver)) {
            throw new IllegalArgumentException(String.format("Expected to wrap a server call stream observer, but got %s; this class can only be used server-side", streamObserver.getClass()));
        }
        return new ErrorMappingStreamObserver<GrpcResponseT>((ServerCallStreamObserver)streamObserver);
    }

    public boolean isReady() {
        return this.delegate.isReady();
    }

    public void setOnReadyHandler(Runnable onReadyHandler) {
        this.delegate.setOnReadyHandler(onReadyHandler);
    }

    public void disableAutoInboundFlowControl() {
        this.delegate.disableAutoInboundFlowControl();
    }

    public void request(int count) {
        this.delegate.request(count);
    }

    public void setMessageCompression(boolean enable) {
        this.delegate.setMessageCompression(enable);
    }

    public void onNext(GrpcResponseT value) {
        this.delegate.onNext(value);
    }

    public void onError(Throwable t) {
        Throwable mapped = t instanceof StatusException || t instanceof StatusRuntimeException ? t : this.errorMapper.mapError(t);
        this.delegate.onError(mapped);
    }

    public void onCompleted() {
        this.delegate.onCompleted();
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public void setOnCancelHandler(Runnable onCancelHandler) {
        this.delegate.setOnCancelHandler(onCancelHandler);
    }

    public void setCompression(String compression) {
        this.delegate.setCompression(compression);
    }

    private void suppressCancelException() {
        this.delegate.setOnCancelHandler(this::onCancel);
    }

    private void onCancel() {
        Loggers.GATEWAY_LOGGER.trace("Attempted to respond to a cancelled call, indicating the client most likely went away");
    }
}

