/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl;

import io.zeebe.gateway.Gateway;
import io.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.stereotype.Component;

@Component
public class SpringGatewayBridge {
    private Supplier<Gateway.Status> gatewayStatusSupplier;
    private Supplier<BrokerClusterState> clusterStateSupplier;

    public void registerGatewayStatusSupplier(Supplier<Gateway.Status> gatewayStatusSupplier) {
        this.gatewayStatusSupplier = gatewayStatusSupplier;
    }

    public void registerClusterStateSupplier(Supplier<BrokerClusterState> clusterStateSupplier) {
        this.clusterStateSupplier = clusterStateSupplier;
    }

    public Optional<Gateway.Status> getGatewayStatus() {
        if (this.gatewayStatusSupplier != null) {
            return Optional.of(this.gatewayStatusSupplier.get());
        }
        return Optional.empty();
    }

    public Optional<BrokerClusterState> getClusterState() {
        if (this.clusterStateSupplier != null) {
            return Optional.ofNullable(this.clusterStateSupplier.get());
        }
        return Optional.empty();
    }
}

