/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.broker;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.Subscription;
import io.atomix.utils.event.EventListener;
import io.zeebe.gateway.Loggers;
import io.zeebe.gateway.impl.broker.BrokerClient;
import io.zeebe.gateway.impl.broker.BrokerRequestManager;
import io.zeebe.gateway.impl.broker.BrokerResponseConsumer;
import io.zeebe.gateway.impl.broker.RoundRobinDispatchStrategy;
import io.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.zeebe.gateway.impl.broker.cluster.BrokerTopologyManagerImpl;
import io.zeebe.gateway.impl.broker.request.BrokerRequest;
import io.zeebe.gateway.impl.broker.response.BrokerResponse;
import io.zeebe.gateway.impl.configuration.ClusterCfg;
import io.zeebe.gateway.impl.configuration.GatewayCfg;
import io.zeebe.transport.ClientTransport;
import io.zeebe.transport.impl.AtomixClientTransportAdapter;
import io.zeebe.util.exception.UncheckedExecutionException;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.clock.ActorClock;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class BrokerClientImpl
implements BrokerClient {
    public static final Logger LOG = Loggers.GATEWAY_LOGGER;
    private static final String ERROR_MSG_STOP_FAILED = "Failed to gracefully shutdown gateway broker client";
    private final ActorScheduler actorScheduler;
    private final BrokerTopologyManagerImpl topologyManager;
    private final AtomixCluster atomixCluster;
    private final boolean ownsActorScheduler;
    private final BrokerRequestManager requestManager;
    private boolean isClosed;
    private Subscription jobAvailableSubscription;

    public BrokerClientImpl(GatewayCfg configuration, AtomixCluster atomixCluster) {
        this(configuration, atomixCluster, null);
    }

    public BrokerClientImpl(GatewayCfg configuration, AtomixCluster atomixCluster, ActorClock actorClock) {
        this(configuration, atomixCluster, ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(configuration.getThreads().getManagementThreads()).setIoBoundActorThreadCount(0).setActorClock(actorClock).setSchedulerName("gateway-scheduler").build(), true);
    }

    public BrokerClientImpl(GatewayCfg configuration, AtomixCluster atomixCluster, ActorScheduler actorScheduler, boolean ownsActorScheduler) {
        this.atomixCluster = atomixCluster;
        this.actorScheduler = actorScheduler;
        this.ownsActorScheduler = ownsActorScheduler;
        if (ownsActorScheduler) {
            actorScheduler.start();
        }
        ClusterCfg clusterCfg = configuration.getCluster();
        ClusterMembershipService membershipService = atomixCluster.getMembershipService();
        this.topologyManager = new BrokerTopologyManagerImpl(() -> ((ClusterMembershipService)membershipService).getMembers());
        actorScheduler.submitActor((Actor)this.topologyManager);
        membershipService.addListener((EventListener)this.topologyManager);
        membershipService.getMembers().forEach(member -> this.topologyManager.event(new ClusterMembershipEvent(ClusterMembershipEvent.Type.MEMBER_ADDED, member)));
        MessagingService messagingService = atomixCluster.getMessagingService();
        AtomixClientTransportAdapter atomixTransportAdapter = new AtomixClientTransportAdapter(messagingService);
        actorScheduler.submitActor((Actor)atomixTransportAdapter);
        this.requestManager = new BrokerRequestManager((ClientTransport)atomixTransportAdapter, this.topologyManager, new RoundRobinDispatchStrategy(this.topologyManager), clusterCfg.getRequestTimeout());
        actorScheduler.submitActor((Actor)this.requestManager);
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        LOG.debug("Closing gateway broker client ...");
        this.doAndLogException(() -> ((BrokerTopologyManagerImpl)this.topologyManager).close());
        LOG.debug("topology manager closed");
        if (this.jobAvailableSubscription != null) {
            this.jobAvailableSubscription.close();
        }
        if (this.ownsActorScheduler) {
            try {
                this.actorScheduler.stop().get(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new UncheckedExecutionException(ERROR_MSG_STOP_FAILED, (Throwable)ie);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new UncheckedExecutionException(ERROR_MSG_STOP_FAILED, (Throwable)e);
            }
        }
        LOG.debug("Gateway broker client closed.");
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequest(BrokerRequest<T> request) {
        return this.requestManager.sendRequest(request);
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequest(BrokerRequest<T> request, Duration requestTimeout) {
        return this.requestManager.sendRequest(request, requestTimeout);
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequestWithRetry(BrokerRequest<T> request) {
        return this.requestManager.sendRequestWithRetry(request);
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequestWithRetry(BrokerRequest<T> request, Duration requestTimeout) {
        return this.requestManager.sendRequestWithRetry(request, requestTimeout);
    }

    @Override
    public <T> void sendRequestWithRetry(BrokerRequest<T> request, BrokerResponseConsumer<T> responseConsumer, Consumer<Throwable> throwableConsumer) {
        this.requestManager.sendRequestWithRetry(request).whenComplete((response, error) -> {
            if (error == null) {
                responseConsumer.accept(response.getKey(), response.getResponse());
            } else {
                throwableConsumer.accept((Throwable)error);
            }
        });
    }

    @Override
    public BrokerTopologyManager getTopologyManager() {
        return this.topologyManager;
    }

    @Override
    public void subscribeJobAvailableNotification(String topic, Consumer<String> handler) {
        this.jobAvailableSubscription = (Subscription)this.atomixCluster.getEventService().subscribe(topic, msg -> {
            handler.accept((String)msg);
            return CompletableFuture.completedFuture(null);
        }).join();
    }

    public <T> void sendRequestWithRetry(BrokerRequest<T> request, BrokerResponseConsumer<T> responseConsumer, Consumer<Throwable> throwableConsumer, Duration requestTimeout) {
        this.requestManager.sendRequestWithRetry(request, requestTimeout).whenComplete((response, error) -> {
            if (error == null) {
                responseConsumer.accept(response.getKey(), response.getResponse());
            } else {
                throwableConsumer.accept((Throwable)error);
            }
        });
    }

    private void doAndLogException(Runnable r) {
        try {
            r.run();
        }
        catch (Exception e) {
            LOG.error("Exception when closing client. Ignoring", (Throwable)e);
        }
    }
}

