/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.broker;

import io.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import io.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;

public final class PartitionIdIterator
implements Iterator<Integer> {
    private final PrimitiveIterator.OfInt iterator;
    private int currentPartitionId;

    public PartitionIdIterator(int startPartitionId, int partitionsCount, BrokerTopologyManager topologyManager) {
        this.iterator = IntStream.range(0, partitionsCount).map(index -> (index + startPartitionId - 1) % partitionsCount + 1).filter(p -> this.hasLeader(topologyManager, p)).iterator();
    }

    private boolean hasLeader(BrokerTopologyManager topologyManager, int p) {
        BrokerClusterState topology = topologyManager.getTopology();
        return topology != null && topology.getLeaderForPartition(p) != -2;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Integer next() {
        this.currentPartitionId = this.iterator.next();
        return this.currentPartitionId;
    }

    public int getCurrentPartitionId() {
        return this.currentPartitionId;
    }
}

