/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.broker;

import io.zeebe.gateway.impl.broker.RequestDispatchStrategy;
import io.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import io.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import java.util.concurrent.atomic.AtomicInteger;

public final class RoundRobinDispatchStrategy
implements RequestDispatchStrategy {
    private final BrokerTopologyManager topologyManager;
    private final AtomicInteger partitions = new AtomicInteger(0);

    public RoundRobinDispatchStrategy(BrokerTopologyManager topologyManager) {
        this.topologyManager = topologyManager;
    }

    @Override
    public int determinePartition() {
        BrokerClusterState topology = this.topologyManager.getTopology();
        if (topology != null) {
            for (int i = 0; i < topology.getPartitionsCount(); ++i) {
                int offset = this.partitions.getAndIncrement();
                int partition = topology.getPartition(offset);
                if (topology.getLeaderForPartition(partition) == -2) continue;
                return partition;
            }
        }
        return -3;
    }
}

