/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.configuration;

import java.net.InetSocketAddress;
import java.util.Objects;

public final class MonitoringCfg {
    private boolean enabled = false;
    private String host;
    private int port = 9600;

    public void init(String defaultHost) {
        if (this.host == null) {
            this.host = defaultHost;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MonitoringCfg setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public MonitoringCfg setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public MonitoringCfg setPort(int port) {
        this.port = port;
        return this;
    }

    public InetSocketAddress toSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitoringCfg that = (MonitoringCfg)o;
        return this.enabled == that.enabled && this.port == that.port && Objects.equals(this.host, that.host);
    }

    public String toString() {
        return "MonitoringCfg{enabled=" + this.enabled + ", host='" + this.host + "', port=" + this.port + "}";
    }
}

