/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.job;

import io.zeebe.gateway.Loggers;
import io.zeebe.gateway.RequestMapper;
import io.zeebe.gateway.ResponseMapper;
import io.zeebe.gateway.cmd.BrokerErrorException;
import io.zeebe.gateway.cmd.BrokerRejectionException;
import io.zeebe.gateway.grpc.ServerStreamObserver;
import io.zeebe.gateway.impl.broker.BrokerClient;
import io.zeebe.gateway.impl.broker.PartitionIdIterator;
import io.zeebe.gateway.impl.broker.RequestDispatchStrategy;
import io.zeebe.gateway.impl.broker.RoundRobinDispatchStrategy;
import io.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import io.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.zeebe.gateway.impl.broker.request.BrokerActivateJobsRequest;
import io.zeebe.gateway.impl.job.ActivateJobsHandler;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import io.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.zeebe.protocol.record.ErrorCode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class RoundRobinActivateJobsHandler
implements ActivateJobsHandler {
    private final Map<String, RequestDispatchStrategy> jobTypeToNextPartitionId = new ConcurrentHashMap<String, RequestDispatchStrategy>();
    private final BrokerClient brokerClient;
    private final BrokerTopologyManager topologyManager;

    public RoundRobinActivateJobsHandler(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
        this.topologyManager = brokerClient.getTopologyManager();
    }

    @Override
    public void activateJobs(GatewayOuterClass.ActivateJobsRequest request, ServerStreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver) {
        BrokerClusterState topology = this.brokerClient.getTopologyManager().getTopology();
        if (topology != null) {
            int partitionsCount = topology.getPartitionsCount();
            this.activateJobs(partitionsCount, RequestMapper.toActivateJobsRequest(request), request.getMaxJobsToActivate(), request.getType(), arg_0 -> responseObserver.onNext(arg_0), arg_0 -> responseObserver.onError(arg_0), (Integer remainingAmount, Boolean resourceExhaustedWasPresent) -> responseObserver.onCompleted());
        }
    }

    public void activateJobs(int partitionsCount, BrokerActivateJobsRequest request, int maxJobsToActivate, String type, Consumer<GatewayOuterClass.ActivateJobsResponse> onResponse, Consumer<Throwable> onError, BiConsumer<Integer, Boolean> onCompleted) {
        this.activateJobs(request, this.partitionIdIteratorForType(type, partitionsCount), maxJobsToActivate, type, onResponse, onError, onCompleted);
    }

    private void activateJobs(BrokerActivateJobsRequest request, PartitionIdIterator partitionIdIterator, int remainingAmount, String jobType, Consumer<GatewayOuterClass.ActivateJobsResponse> onResponse, Consumer<Throwable> onError, BiConsumer<Integer, Boolean> onCompleted) {
        this.activateJobs(request, partitionIdIterator, remainingAmount, jobType, onResponse, onError, onCompleted, false, false);
    }

    private void activateJobs(BrokerActivateJobsRequest request, PartitionIdIterator partitionIdIterator, int remainingAmount, String jobType, Consumer<GatewayOuterClass.ActivateJobsResponse> onResponse, Consumer<Throwable> onError, BiConsumer<Integer, Boolean> onCompleted, boolean pollPrevPartition, boolean resourceExhaustedWasPresent) {
        if (remainingAmount > 0 && (pollPrevPartition || partitionIdIterator.hasNext())) {
            int partitionId = pollPrevPartition ? partitionIdIterator.getCurrentPartitionId() : partitionIdIterator.next().intValue();
            request.setPartitionId(partitionId);
            request.setMaxJobsToActivate(remainingAmount);
            this.brokerClient.sendRequest(request).whenComplete((response, error) -> {
                if (error == null) {
                    GatewayOuterClass.ActivateJobsResponse grpcResponse = ResponseMapper.toActivateJobsResponse(response.getKey(), (JobBatchRecord)response.getResponse());
                    int jobsCount = grpcResponse.getJobsCount();
                    if (jobsCount > 0) {
                        onResponse.accept(grpcResponse);
                    }
                    this.activateJobs(request, partitionIdIterator, remainingAmount - jobsCount, jobType, onResponse, onError, onCompleted, ((JobBatchRecord)response.getResponse()).getTruncated(), resourceExhaustedWasPresent);
                } else {
                    boolean wasResourceExhausted = this.wasResourceExhausted((Throwable)error);
                    if (this.isRejection((Throwable)error)) {
                        onError.accept((Throwable)error);
                        return;
                    }
                    if (!wasResourceExhausted) {
                        this.logErrorResponse(partitionIdIterator, jobType, (Throwable)error);
                    }
                    this.activateJobs(request, partitionIdIterator, remainingAmount, jobType, onResponse, onError, onCompleted, false, wasResourceExhausted);
                }
            });
        } else {
            onCompleted.accept(remainingAmount, resourceExhaustedWasPresent);
        }
    }

    private boolean isRejection(Throwable error) {
        return error != null && BrokerRejectionException.class.isAssignableFrom(error.getClass());
    }

    private boolean wasResourceExhausted(Throwable error) {
        if (error instanceof BrokerErrorException) {
            BrokerErrorException brokerError = (BrokerErrorException)error;
            return brokerError.getError().getCode() == ErrorCode.RESOURCE_EXHAUSTED;
        }
        return false;
    }

    private void logErrorResponse(PartitionIdIterator partitionIdIterator, String jobType, Throwable error) {
        Loggers.GATEWAY_LOGGER.warn("Failed to activate jobs for type {} from partition {}", new Object[]{jobType, partitionIdIterator.getCurrentPartitionId(), error});
    }

    private PartitionIdIterator partitionIdIteratorForType(String jobType, int partitionsCount) {
        RequestDispatchStrategy nextPartitionSupplier = this.jobTypeToNextPartitionId.computeIfAbsent(jobType, t -> new RoundRobinDispatchStrategy(this.topologyManager));
        return new PartitionIdIterator(nextPartitionSupplier.determinePartition(), partitionsCount, this.topologyManager);
    }
}

