/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.probes.health;

import io.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class ClusterAwarenessHealthIndicator
implements HealthIndicator {
    private final Supplier<Optional<BrokerClusterState>> clusterStateSupplier;

    public ClusterAwarenessHealthIndicator(Supplier<Optional<BrokerClusterState>> clusterStateSupplier) {
        this.clusterStateSupplier = Objects.requireNonNull(clusterStateSupplier);
    }

    public Health health() {
        Optional<BrokerClusterState> optClusterState = this.clusterStateSupplier.get();
        if (optClusterState.isEmpty()) {
            return Health.down().build();
        }
        if (optClusterState.get().getBrokers().isEmpty()) {
            return Health.down().build();
        }
        return Health.up().build();
    }
}

