/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.probes.liveness;

import io.zeebe.gateway.impl.configuration.GatewayCfg;
import io.zeebe.gateway.impl.probes.health.ResponsiveHealthIndicator;
import io.zeebe.gateway.impl.probes.liveness.LivenessResponsiveHealthIndicatorProperties;
import io.zeebe.util.health.DelayedHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthContributorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration(proxyBeanMethods=false)
@ConditionalOnEnabledHealthIndicator(value="gateway-responsive")
@AutoConfigureBefore(value={HealthContributorAutoConfiguration.class})
@EnableConfigurationProperties(value={LivenessResponsiveHealthIndicatorProperties.class})
@EnableScheduling
public class LivenessResponsiveHealthIndicatorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"livenessGatewayResponsiveHealthIndicator"})
    public HealthIndicator livenessGatewayResponsiveHealthIndicator(GatewayCfg gatewayCfg, LivenessResponsiveHealthIndicatorProperties properties) {
        return new DelayedHealthIndicator((HealthIndicator)this.gatewayResponsiveHealthIndicator(gatewayCfg, properties), properties.getMaxDowntime());
    }

    private ResponsiveHealthIndicator gatewayResponsiveHealthIndicator(GatewayCfg gatewayCfg, LivenessResponsiveHealthIndicatorProperties properties) {
        return new ResponsiveHealthIndicator(gatewayCfg, properties.getRequestTimeout());
    }
}

