/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.probes.liveness;

import io.zeebe.util.health.AbstractDelayedHealthIndicatorProperties;
import java.time.Duration;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="management.health.liveness.gateway-responsive")
public class LivenessResponsiveHealthIndicatorProperties
extends AbstractDelayedHealthIndicatorProperties {
    private Duration requestTimeout = Duration.ofSeconds(5L);

    protected Duration getDefaultMaxDowntime() {
        return Duration.ofMinutes(10L);
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        if (Objects.requireNonNull(requestTimeout).toMillis() <= 0L) {
            throw new IllegalArgumentException("requestTimeout must be greater than 0");
        }
        this.requestTimeout = requestTimeout;
    }
}

