/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class Generics {
    private Generics() {
    }

    public static Type getGenericClassType(Object instance, Class<?> clazz, int position) {
        Class<?> type = instance.getClass();
        while (type != Object.class) {
            if (type.getGenericSuperclass() instanceof ParameterizedType) {
                ParameterizedType genericSuperclass = (ParameterizedType)type.getGenericSuperclass();
                if (genericSuperclass.getRawType() == clazz) {
                    return genericSuperclass.getActualTypeArguments()[position];
                }
                type = type.getSuperclass();
                continue;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    public static Type getGenericInterfaceType(Object instance, Class<?> iface, int position) {
        for (Class<?> type = instance.getClass(); type != Object.class; type = type.getSuperclass()) {
            for (Type genericType : type.getGenericInterfaces()) {
                ParameterizedType parameterizedType;
                if (!(genericType instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)genericType).getRawType() != iface) continue;
                return parameterizedType.getActualTypeArguments()[position];
            }
        }
        return null;
    }
}

