/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.atomix.utils.concurrent.Accumulator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccumulator<T>
implements Accumulator<T> {
    private Logger log = LoggerFactory.getLogger(AbstractAccumulator.class);
    private final Timer timer;
    private final int maxItems;
    private final int maxBatchMillis;
    private final int maxIdleMillis;
    private final AtomicReference<TimerTask> idleTask = new AtomicReference();
    private final AtomicReference<TimerTask> maxTask = new AtomicReference();
    private final List<T> items;

    protected AbstractAccumulator(Timer timer, int maxItems, int maxBatchMillis, int maxIdleMillis) {
        this.timer = (Timer)Preconditions.checkNotNull((Object)timer, (Object)"Timer cannot be null");
        Preconditions.checkArgument((maxItems > 1 ? 1 : 0) != 0, (Object)"Maximum number of items must be > 1");
        Preconditions.checkArgument((maxBatchMillis > 0 ? 1 : 0) != 0, (Object)"Maximum millis must be positive");
        Preconditions.checkArgument((maxIdleMillis > 0 ? 1 : 0) != 0, (Object)"Maximum idle millis must be positive");
        this.maxItems = maxItems;
        this.maxBatchMillis = maxBatchMillis;
        this.maxIdleMillis = maxIdleMillis;
        this.items = Lists.newArrayListWithExpectedSize((int)maxItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(T item) {
        int sizeAtTimeOfAdd;
        List<T> list = this.items;
        synchronized (list) {
            this.items.add(item);
            sizeAtTimeOfAdd = this.items.size();
        }
        if (sizeAtTimeOfAdd >= this.maxItems) {
            if (this.maxIdleMillis < this.maxBatchMillis) {
                this.cancelTask(this.idleTask);
            }
            this.rescheduleTask(this.maxTask, 0L);
        } else {
            if (this.maxIdleMillis < this.maxBatchMillis) {
                this.rescheduleTask(this.idleTask, this.maxIdleMillis);
            }
            if (sizeAtTimeOfAdd == 1) {
                this.rescheduleTask(this.maxTask, this.maxBatchMillis);
            }
        }
    }

    @Override
    public boolean isReady() {
        return true;
    }

    private void rescheduleTask(AtomicReference<TimerTask> taskRef, long millis) {
        ProcessorTask newTask = new ProcessorTask();
        this.timer.schedule((TimerTask)newTask, millis);
        this.swapAndCancelTask(taskRef, newTask);
    }

    private void cancelTask(AtomicReference<TimerTask> taskRef) {
        this.swapAndCancelTask(taskRef, null);
    }

    private void swapAndCancelTask(AtomicReference<TimerTask> taskRef, TimerTask newTask) {
        TimerTask oldTask = taskRef.getAndSet(newTask);
        if (oldTask != null) {
            oldTask.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> finalizeCurrentBatch() {
        ImmutableList finalizedList;
        List<T> list = this.items;
        synchronized (list) {
            finalizedList = ImmutableList.copyOf(this.items);
            this.items.clear();
            this.cancelTask(this.maxTask);
            this.cancelTask(this.idleTask);
        }
        return finalizedList;
    }

    public Timer timer() {
        return this.timer;
    }

    public int maxItems() {
        return this.maxItems;
    }

    public int maxBatchMillis() {
        return this.maxBatchMillis;
    }

    public int maxIdleMillis() {
        return this.maxIdleMillis;
    }

    private class ProcessorTask
    extends TimerTask {
        private ProcessorTask() {
        }

        @Override
        public void run() {
            try {
                if (AbstractAccumulator.this.isReady()) {
                    List batch = AbstractAccumulator.this.finalizeCurrentBatch();
                    if (!batch.isEmpty()) {
                        AbstractAccumulator.this.processItems(batch);
                    }
                } else {
                    AbstractAccumulator.this.rescheduleTask(AbstractAccumulator.this.idleTask, AbstractAccumulator.this.maxIdleMillis);
                }
            }
            catch (Exception e) {
                AbstractAccumulator.this.log.warn("Unable to process batch due to", (Throwable)e);
            }
        }
    }
}

